#Author: Arsenii Kostenko
import numpy as np
from sklearn.linear_model import LogisticRegression
import gradio as gr

# Данные для обучения модели
x_train = np.array([[0, 0], [1, 1], [2, 2]])
y_train = np.array([0, 1, 2])

# Обучение модели
model = LogisticRegression()
model.fit(x_train, y_train)

# Функция для предсказания значений
def predict(x, y):
    # Преобразование строк в списки списков
    x_nested_list = [list(map(int, sublist.split(","))) for sublist in x.split(";")]
    y_nested_list = [list(map(int, sublist.split(","))) for sublist in y.split(";")]

    # Преобразование списков списков в numpy arrays
    x_array = np.array(x_nested_list)
    y_array = np.array(y_nested_list)

    # Проверка исходных данных на соответствие
    if x_array.shape != y_array.shape:
        return "Ошибка: x и y должны иметь одинаковую размерность"
    
    # Предсказание значений
    predictions = model.predict(x_array)

    return predictions

# Создание интерфейса gradio
iface = gr.Interface(
    fn=predict,
    inputs=["text", "text"],
    outputs="text"
)

iface.launch(debug=True)