#Author: Arsenii Kostenko
import numpy as np
from sklearn.linear_model import LinearRegression, LogisticRegression
import gradio as gr

# Данные для обучения моделей
x_train = np.array([[0, 0], [1, 1], [2, 2]])
y_train = np.array([0, 1, 2])

# Обучение моделей
linear_model = LinearRegression()
linear_model.fit(x_train, y_train)

logistic_model = LogisticRegression()
logistic_model.fit(x_train, y_train)

# Функция для предсказания значений линейной регрессии
def predict_linear(x, y):
    # Преобразование строк в список списков
    x_nested_list = [list(map(int, sublist.split(","))) for sublist in x.split(";")]
    y_nested_list = [list(map(int, sublist.split(","))) for sublist in y.split(";")]

    # Преобразование списка списков в numpy array
    x_array = np.array(x_nested_list)
    y_array = np.array(y_nested_list)

    # Проверка исходных данных на соответствие
    if x_array.shape != y_array.shape:
        return "Ошибка: x и y должны иметь одинаковую размерность"

    # Предсказание значений для линейной регрессии
    predictions = linear_model.predict(x_array)

    return predictions

# Функция для предсказания значений логистической регрессии
def predict_logistic(x, y):
    # Преобразование строк в список списков
    x_nested_list = [list(map(int, sublist.split(","))) for sublist in x.split(";")]
    y_nested_list = [list(map(int, sublist.split(","))) for sublist in y.split(";")]

    # Преобразование списка списков в numpy array
    x_array = np.array(x_nested_list)
    y_array = np.array(y_nested_list)

    # Проверка исходных данных на соответствие
    if x_array.shape != y_array.shape:
        return "Ошибка: x и y должны иметь одинаковую размерность"

    # Предсказание значений для логистической регрессии
    predictions = logistic_model.predict(x_array)

    return predictions

# Создание интерфейса gradio для линейной регрессии
interface_linear = gr.Interface(
    fn=predict_linear,
    inputs=["text", "text"],
    outputs="text",
    title="Линейная регрессия"
)

# Создание интерфейса gradio для логистической регрессии
interface_logistic = gr.Interface(
    fn=predict_logistic,
    inputs=["text", "text"],
    outputs="text",
    title="Логистическая регрессия"
)

# Запуск обоих интерфейсов
interface_linear.launch(debug=True)
interface_logistic.launch(debug=True)