import openai
import gradio as gr
import os

openai.api_key = os.environ["openai_key"]

def gpt4(instruction, email):
    completion = openai.ChatCompletion.create(
      model="gpt-4",
      messages=[
        {"role": "system", "content": f'{instruction}'},
        {"role": "user", "content": f"{email}"},
      ], temperature=0,
    )

    return completion.choices[0].message.content

# Define the Gradio input and output interfaces
inputs = [
    gr.inputs.Textbox(label="Instruction"),
    gr.inputs.Textbox(label="Email")
]
output = gr.outputs.Textbox(label="Output")

# Create a Gradio interface and launch it
gr.Interface(fn=gpt4, inputs=inputs, outputs=output, title="GPT-4 Demo").launch()
