import urllib.request
from json import dumps
from datetime import datetime
from random import choice
from string import ascii_letters,digits
from time import sleep
import gradio as gr

demo = gr.Blocks()


def genString(stringLength):
	try:
		letters = ascii_letters + digits
		return ''.join(choice(letters) for i in range(stringLength))
	except Exception as error:
		print(error)

def digitString(stringLength):
	try:
		digit = digits
		return ''.join((choice(digit) for i in range(stringLength)))
	except Exception as error:
		print(error)	
url = f'https://api.cloudflareclient.com/v0a{digitString(3)}/reg'

def task(ID):
	try:
		install_id = genString(22)
		body = {"key": "{}=".format(genString(43)),
				"install_id": install_id,
				"fcm_token": "{}:APA91b{}".format(install_id, genString(134)),
				"referrer": ID,
				"warp_enabled": False,
				"tos": datetime.now().isoformat()[:-3] + "+02:00",
				"type": "Android",
				"locale": "es_ES"}
		data = dumps(body).encode('utf8')
		headers = {'Content-Type': 'application/json; charset=UTF-8',
					'Host': 'api.cloudflareclient.com',
					'Connection': 'Keep-Alive',
					'Accept-Encoding': 'gzip',
					'User-Agent': 'okhttp/3.12.1'
					}
		req         = urllib.request.Request(url, data, headers)
		response    = urllib.request.urlopen(req)
		status_code = response.getcode()
		return status_code
	except Exception as error:
		print(error)

def run(ID,times):
	g = 0
	b = 0

	for i in range (0,int(times)):
		result = task(ID)
		if result == 200:
			g = g + 1
		else:
			b = b + 1
		sleep(2)

	return (f"您的ID: {ID}\n{g} GB 已成功添加到您的账号.\n成功{g}个 | 失败{b}个")

with demo:
	gr.Markdown("""
# Warp+ 流量获取工具
```
    ___         _      __                 \n   / _ |  ____ (_)___ / /_ ___   ____ ___ \n  / __ | / __// /(_-</ __// _ \ / __// -_)\n /_/ |_|/_/  /_//___/\__/ \___//_/   \__/ \n

本程序由 Aristore 制作,转载请说明出处,有问题欢迎私信我
bilibil:https://space.bilibili.com/283733002
github:https://github.com/aristorechina/

注意:流量可多次获取,但每次获取输入的数字不能过大,每获取 1 GB 会间隔 2 秒
``` 
""")
	with gr.Tabs():
		with gr.TabItem("获取流量"):
			with gr.Row():
				with gr.Column():
					ID = gr.Textbox(label="ID")
					flow = gr.Number(minimum=1,value=1,label="需要获取的流量数(单位:GB)")
				with gr.Column():
					output = gr.Textbox(label="输出")
					get_flow = gr.Button("获取流量")

	get_flow.click(run, inputs=[ID,flow], outputs=output)

demo.launch()