import gradio as gr
import PIL
import numpy
import matplotlib.pyplot as plt
#load the trained model to classify sign
from keras.models import load_model
model = load_model('traffic_classifier.h5')
#dictionary to label all traffic signs class.
classes = { 1:'Speed limit (20km/h)',
            2:'Speed limit (30km/h)', 
            3:'Speed limit (50km/h)', 
            4:'Speed limit (60km/h)', 
            5:'Speed limit (70km/h)', 
            6:'Speed limit (80km/h)', 
            7:'End of speed limit (80km/h)', 
            8:'Speed limit (100km/h)', 
            9:'Speed limit (120km/h)', 
            10:'Veh > 3.5 tons prohibited', 
            11:'Bumpy road',
            12:'Slippery road', 
            13:'Road narrows on the right', 
            14:'Road work', 
            15:'Pedestrians', 
            16:'Turn right ahead', 
            17:'Turn left ahead', 
            18:'Ahead only', 
            19:'Go straight or right', 
            20:'Go straight or left', 
            21:'Keep right', 
            22:'Keep left', 
            23:'Roundabout mandatory'}
#initialise GUI
def predict(img):
  img = numpy.expand_dims(img, axis=0)
  predict_x = model.predict(img)
  pred = numpy.argmax(predict_x, axis = 1)
  sign = classes[pred[0]+1]
  return sign
gr.Interface(fn= predict, inputs = gr.inputs.Image(shape = (30,30)), outputs= "textbox" ).launch(share=True, debug = True)