from re import I
from tkinter import image_names
import gradio as gr
import torch
import requests
from PIL import Image
from torchvision import transforms, models
from torch import nn
import torch.nn.functional as F

# Load the model
def load_model():
    model = models.efficientnet_b4(pretrained = True).cpu()
    model.classifier[1] = nn.Linear(in_features=1792, out_features=13)
    model.load_state_dict(torch.load('model.pth',map_location=torch.device('cpu')))
    model.eval()
    return model


# Load the labels
def load_labels():
    labels = open('classes.txt').read().splitlines()
    return labels


# Accessing the model and labels
model = load_model()
labels = load_labels()

# Define the preprocessing function
def preprocess(image):
    image = Image.fromarray(image.astype('uint8'), 'RGB')
    r_image = transforms.Compose([transforms.Resize((380,380)),transforms.ToTensor(), 
                                             transforms.Normalize(mean = [0.485, 0.456, 0.406], std = [0.229, 0.224, 0.225])])(image)
    
    return r_image

# Define prediction function with probability and top 3 predictions
def predict(image):
    image = preprocess(image)
    image = image.unsqueeze(0)
    output = model(image)
    prob, pred = torch.topk(F.softmax(output, dim=1), k=3)
    prob = prob.detach().numpy().tolist()[0]
    pred = pred.detach().numpy().tolist()[0]
    confidences = {labels[pred[i]]: float(prob[i]) for i in range(3)}
    return confidences



# Define the interface
title = "Kenya Food Classification"
description = "Classify Kenyan food into 13 categories"
article = "<p style='text-align: center'><a href='https://github.com/ariharasudhanm/Image_classification_Kaggle_Competition'>Github</a> | <a href='https://www.linkedin.com/in/ariharasudhan/'>LinkedIn</a></p>"
examples = ["./test1.jpeg", "./test2.jpeg", "./test3.jpeg"]
gr.Interface(predict, "image", "label", title=title, description=description, article=article, examples=examples).launch()


