import openai, os
import gradio as gr

openai.api_key = os.environ.get("OPENAI_API_KEY")

class Conversation2:
    def __init__(self, prompt,):
        self.prompt = prompt
        self.messages = []
        self.messages.append({"role": "system", "content": self.prompt})

    def ask(self, question):
        try:
            self.messages.append( {"role": "user", "content": question})
            response = openai.ChatCompletion.create(
                model="gpt-3.5-turbo",
                messages=self.messages,
                temperature=0.5,
                max_tokens=2048,
                top_p=1,
            )
        except Exception as e:
            print(e)
            return e

        message = response["choices"][0]["message"]["content"]
        num_of_tokens = response['usage']['total_tokens']
        self.messages.append({"role": "assistant", "content": message})
        
         # 删除最开始的对话，直到Token数量不超标
        while num_of_tokens > 2048:
            del self.messages[1:3]
            num_of_tokens = num_of_tokens - len(self.messages[1]["content"].split())

        return message, num_of_tokens


prompt = """你是一个计算机助手，你尽力回答一切问题。"""

conv = Conversation2(prompt)

def answer(question, history=[]):
    history.append(question)
    response,num_of_tokens = conv.ask(question)
    history.append(response)
    responses = [(u,b) for u,b in zip(history[::2], history[1::2])]
    return responses, history

with gr.Blocks(css="#chatbot{height:600px} .overflow-y-auto{height:500px}") as demo:
    chatbot = gr.Chatbot(elem_id="chatbot")
    state = gr.State([])

    with gr.Row():
        txt = gr.Textbox(show_label=False, placeholder="Enter text and press enter")

    txt.submit(answer, [txt, state], [chatbot, state])

demo.launch()