from email import message
import gradio as gr
import os
import openai
from create_poll import create_poll
from utils import GPTCompletion
from dotenv import load_dotenv

gr.close_all()

load_dotenv()

openai.api_key = os.environ["OPENAI_API_KEY"]



def chatWithGPT(chatHistory):
    completion = GPTCompletion(system="You are an AI chatting with a human.", max_tokens=2048, temperature=1.5)
    gptResponse = completion.chatComplete(chatHistory)
    chatHistory[-1][1] = gptResponse
    return chatHistory

with gr.Blocks() as demo:
    chatHistory = gr.State(value = [])

    def generateResponse(message, chatHistory):
        completion = GPTCompletion(system="You are an AI chatting with a human.", max_tokens=2048, temperature=1.5)
        gptResponse = completion.chatComplete(chatHistory,message)
        chatHistory.append((message, gptResponse))
        return chatHistory

    def pollinize(chatHistory):

        chatList = []
        for log in chatHistory:
            chatList.append("User: " + log[0])
            chatList.append("AI: " + log[1])
        chatString = "\n".join(chatList)

        return create_poll(chatString, openai.api_key)

    def uploadApi(apikey):
        openai.api_key = apikey

    gr.Markdown("This little app is a demonstration of how LLMs can be used to create Polls from a chat. To give it a try, discuss a topic with ChatGPT first and then push Generate Poll button. Poll question will be generated on the context of the chat.")

    chatbot = gr.Chatbot().style(height=460)
    input = gr.Textbox(label="Messeage")
    nextBtn = gr.Button("Send message")
    nextBtn.click(generateResponse, [input, chatHistory], chatbot, scroll_to_output=True, show_progress=True)

    debatePoll = gr.Textbox(label="Poll")
    pollinizeButton = gr.Button("Create a poll")
    pollinizeButton.click(pollinize,chatHistory, debatePoll, scroll_to_output=True, show_progress=True)

    apikey = gr.Textbox(label="API Key")
    apiUpload = gr.Button("Upload custom api key")
    apiUpload.click(uploadApi, apikey, None, scroll_to_output=True, show_progress=True)
    
demo.launch()