import os
import streamlit as st
from pdfminer.high_level import extract_pages
from search import search
from get_paper import get_paper
from get_pages import get_pages
from tts import inference

st.title("ArXiV Audio")

with st.form(key="search_form"):
    col1, col2, col3 = st.columns(3)
    with col1:
        query = st.text_input("Search Paper")
    with col2:
        sort_by = st.selectbox(label="Sort By", options=(
            'Relevance', 'Last Updated Date', 'Submitted Date'))
    with col3:
        order_by = st.selectbox(
            label="Order By", options=('Ascending', 'Descending'))
    submit = st.form_submit_button(label="Search")

lst = search(query=query, sort_by=sort_by, sort_order=order_by)
if len(lst) != 0:
    label = "Papers for " + query
    with st.form(key="paper_form"):
        pname = st.selectbox(label=label, options=lst)
        submit_paper = st.form_submit_button(label="Fetch Paper")
else:
    with st.form(key="paper_form"):
        pname = st.selectbox(label="NO PAPERS", options=lst)
        submit_paper = st.form_submit_button(label="Fetch Paper")

paper = ""
if submit_paper or os.path.exists('downloads/paper.pdf'):
    paper = get_paper(pname)

    print("Submit_paper = ", submit_paper)

    name = ""
    tpages = 0
    lst_idx = 1
    if paper:
        name = "./downloads/paper.pdf"
        tpages = len(list(extract_pages(name)))
        lst_idx = tpages-1

    pgs = [i+1 for i in range(tpages)]

    start_page = 1
    end_page = 1
    #content = get_pages(name, start_page, end_page)
    #audio_path = inference(content, "english")
    #audio_file = open(audio_path, "rb")
    #audio_bytes = audio_file.read()
    #st.audio(audio_bytes, format='audio/wav')

    with st.form(key="page_form"):
        print("inside page form")
        col4, col5 = st.columns(2)
        with col4:
            print("column 1")
            s_page = st.selectbox(label="Start Page", options=pgs)
            print(s_page)
            start_page = s_page
        with col5:
            print("column 2")
            e_page = st.selectbox(label="End Page", options=pgs, index=lst_idx)
            print(e_page)
            end_page = e_page
        st.text("*")
        submit_pages = st.form_submit_button(label="Convert To Audio")
        print("Submit_pages' = ", submit_pages)
    print(start_page, end_page)

    print("Submit_pages = ", submit_pages)
    if submit_pages:
        content = get_pages(name, start_page, end_page)
        x = st.text("Converting to Audio..... Please Wait")
        audio_path = inference(content, "english")
        audio_file = open(audio_path, "rb")
        audio_bytes = audio_file.read()
        x = st.text("Done")
        st.audio(audio_bytes, format='audio/wav')
        os.remove('downloads/paper.pdf')

    print("Submit_paper at end state = ", submit_paper)


else:
    with st.form(key="page_form"):
        col1, col2 = st.columns(2)
        with col1:
            s_page = st.selectbox(label="Start Page", options=[])
        with col2:
            e_page = st.selectbox(label="End Page", options=[])
        submit_pages2 = st.form_submit_button(label="Convert To Audio")
st.text(" ")
st.text(" ")
st.text(" ")
st.text(" ")
st.text(" ")      
st.markdown("Created by [Archan Ghosh](https://github.com/ArchanGhosh) & [Madhurima Maji](https://github.com/madhurima99). Special Thanks to [Herumb](https://github.com/krypticmouse) for helping us with the deployment.", unsafe_allow_html=True)
st.markdown("Do Support us on [Github](https://github.com/ArchanGhosh/ArxivAudio)", unsafe_allow_html =True)
st.text(" ")
st.text("* - Please limit to 3 pages as we are currently rate limited on CPU, we are planning to move to a GPU in the coming future. ")