import tensorflow as tf 
import gradio as gr
import cv2
import numpy as np 

new_model = tf.keras.models.load_model('breedclassification.h5')

def predict_classes(link): 
    img = cv2.resize(link,(224,224))
    img = img/255
    img = img.reshape(-1,224,224,3)   
    pred = np.round(new_model.predict(img)).argmax(axis = 1)
    dic = {0: 'Herding breed', 1: 'Hound breed', 2: 'Non sporting breed', 3: 'Terrior breed', 4:'working breed', 5: 'sporting breed', 6: 'toy breed'}
    print(dic.get(int(pred)))
    a = dic.get(int(pred))
    return a
    
label = gr.outputs.Label(num_top_classes=7)
gr.Interface(fn=predict_classes, inputs='image', outputs=label,interpretation='default',  title = 'Breed Classification detection ',  description = 'It will classify 7 different species: You can drage the images from google. 1. Terrier 2. Toy 3. Working 4. Sporting 5. Haund 6. Herding 7. Non sporting Group ').launch() 