import gradio as gr
from fastai.text.all import *

# to fix : NotImplementedError: cannot instantiate 'PosixPath' on your system
# import pathlib
# temp = pathlib.PosixPath
# pathlib.PosixPath = pathlib.WindowsPath

examples=['This was a fantastic end to the trilogy.','I\'ve never seen a bigger waste of my time.','Just when we thought they couldn\'t possibly make a worse TV movie than Sharknado? Syfy says, "Hold my beer!"']

learn=load_learner('imdb_review_sentiment_model.pkl')

class_names=['neg','pos']

def classify(review):
    _,_,pob=learn.predict(review)
    return dict(zip(class_names,map(float,pob)))

iface = gr.Interface(fn=classify, inputs=gr.inputs.Textbox(), outputs=gr.outputs.Label(),examples=examples)
iface.launch()