from PIL import Image
import base64
from io import BytesIO
from pydantic import BaseModel, validator

def img_to_base64(img):
    buffer = BytesIO()
    img.save(buffer, "jpeg")
    content = base64.b64encode(buffer.getvalue())
    return str(content, 'utf-8')

def base64_to_img(content):
    decoded_image = base64.b64decode(content)
    image_buffer = BytesIO(decoded_image)
    image = Image.open(image_buffer)
    return image

def resize_image(img, maxlen=2048):
    if max(img.size)<maxlen:
        return img
    if img.width > img.height:
        img = img.resize((maxlen, int(img.height*maxlen/img.width)//8*8))
    else:
        img = img.resize((int(img.width*maxlen/img.height)//8*8, maxlen))
    return img
