#!/bin/bash
set -e

if [ -z ${JUPYTER_TOKEN+x} ]; then echo "Please export JUPYTER_TOKEN from your '.env' file"; exit -2 ; fi 

jupyter lab \
    --ip "0.0.0.0" \
    --port 7860 \
    --no-browser \
    --allow-root \
    --ServerApp.token="$JUPYTER_TOKEN" \
    --ServerApp.tornado_settings="{'headers': {'Content-Security-Policy': 'frame-ancestors *'}}" \
    --ServerApp.cookie_options="{'SameSite': 'None', 'Secure': True}" \
    --ServerApp.disable_check_xsrf=True \
    --LabApp.news_url=None \
    --LabApp.check_for_updates_class="jupyterlab.NeverCheckForUpdate"