from typing import Optional


print(
    f"executing the file '{__file__}'"
    f"in module '{__name__}' and package '{__package__}'"
)


def build_greetings(name: Optional[str] = None) -> str:
    """
    Return a greeting message, possibly customize with a name.

    >>> build_greetings()
    'Hello, World!'
    >>> build_greetings('Toto')
    'Nice to meet you, Toto!'
    """
    return name and f"Nice to meet you, {name}!" or "Hello, World!"


def main():
    print(build_greetings())


if __name__ == "__main__":
    main()  # pragma: no cover
