#!/usr/bin/env bash
source $(dirname $0)/common_header.sh

# During development ONLY use a `bind mount` to enable
# editing the code without having to rebuild the container.
docker run --rm -it                                           \
    -p 8501:8501 -p 7860:7860                                 \
    --env-file ${ROOT_DIRECTORY}/.env                         \
    --mount type=volume,src=$VOLUME_NAME,dst=/data            \
    --mount type=bind,source=${ROOT_DIRECTORY}/src/,target=/app/,readonly                        \
    --mount type=bind,source=${ROOT_DIRECTORY}/.streamlit,target=/user/.streamlit,readonly       \
    $CONTAINER_NAME:latest                                    \
    $@ # Pass all command line argument quoted in a good way


