# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.14.7
#   kernelspec:
#     display_name: Python 3 (ipykernel)
#     language: python
#     name: python3
# ---

# %%
import os
from pathlib import Path

import numpy as np
import pandas as pd

# %%
from athai.data_utils import cached_download_csv

# %%
DATE_COLUMN = "date/time"
DATA_URL = (
    "https://s3-us-west-2.amazonaws.com/"
    "streamlit-demo-data/uber-raw-data-sep14.csv.gz"
)

DATA_PATH = Path(os.environ.get("APP_DATA"))


# %%
nrows=10
data = cached_download_csv(DATA_PATH, DATA_URL, nrows=nrows)
data

# %%

# %%
