---
title: Jupyter and Streamlit Docker Template
emoji: 📉
colorFrom: blue
colorTo: green
sdk: docker
python_version: "3.10"
app_port: 7860
app_file: src/app.py
suggested_storage: small
pinned: false
duplicated_from: SpacesExamples/streamlit-docker-example
---

# 🧠 Persistent Jupyter and Streamlit Docker Template 🔎

Streamlit Docker Template is a template for creating a Streamlit app with Docker and Hugging Face Spaces.

Code from https://docs.streamlit.io/library/get-started/create-an-app

## Local execution ##

You need *Docker* installed.
On MacOSX we recommand using *colima* if you do not want to use *Docker Desktop*
for licensing reasons.

* https://docs.docker.com/desktop/install/mac-install/
* https://github.com/abiosoft/colima

```shell
$ colima start --cpu 4 --memory 16 --network-address # Adjust ressources as you wish
$ docker build -t persistent-docker-space .
$ docker run -it -p 8501:8501 persistent-docker-space:latest

```

## Setting-up the developpers'tooling

### Install `poetry`

https://python-poetry.org/

#### Linux and Mac

It should be straightforward with the official documentation

#### Windows (PowerShell)

```shell
(Invoke-WebRequest -Uri https://install.python-poetry.org -UseBasicParsing).Content | py -
```

The execution will probably be stored at the address: `C:\User\<myUserName>\AppData\Roaming\pypoetry\venv\Scripts` and this
path should be included in the environment path of your machine in order to avoid typing it every time poetry is used.
To do so you can execute the following commands:

```shell
$Env:Path += ";C:\Users\YourUserName\AppData\Roaming\Python\Scripts"
```

This will only make the change in the path temporarily. In order to do it permanently you can execute the following command
```shell
setx PATH "$Env:Path"
```

### Configuration of the `poetry` environment

After having installed poetry in your local machine, if there is already a `poetry.lock` file on your repository, you
can execute

```shell
poetry install
```

If it is not the case you can

```shell
poetry init
poetry env use "whatever version of python you have in your local machine (compatible with the project)"
poetry shell
```

### pre-commit

https://pre-commit.com/

If there is already a `poetry.lock` file with `pre-commit` present in it, you should activate your poetry environment
and then install all the pre-commit hooks on your machine

```shell
poetry shell
pre-commit install
pre-commit install --install-hooks
```

If not, you should first add `pre-commit` to your poetry environment, and follow the steps above

```shell
poetry add --group=dev pre-commit
```

### commitizen

https://www.conventionalcommits.org/en/about/

https://commitizen-tools.github.io/commitizen/


Commitizen will be installed as a pre-commit hook. In order for it to be executed before committing
you should run the following command (after activating your poetry environment)

```shell
pre-commit install --hook-type commit-msg
```

Finally, every time you will be committing, you should be places in your poetry environment and commitizen hooks
should be applied

### testing

There are two different kinds of tests that can be run when testing the scripts: unit tests or doctest

These tests can be run by executing the following command:

```shell
./scripts/run-tests.sh
```

#### pytest

https://docs.pytest.org/en/7.2.x/

These tests should be stored in the directory `tests` at the root of the project

#### xdoctest (driven by pytest)

These are the tests that are put in the docstrings of the functions accordingly to the following format:

```python
    def build_greetings(name: Optional[str] = None) -> str:
        """
            Return a greeting message, possibly customize with a name.

            >>> build_greetings()
            'Hello, World!'
            >>> build_greetings('Toto')
            'Nice to meet you, Toto!'
        """
        return name and f"Nice to meet you, {name}!" or "Hello, World!"
```

The evaluated values would be the ones following the `>>>`

### documentation

https://www.sphinx-doc.org/en/master/

In order to create an automatic documentation of your code you should run the bash script

```shell
./scripts/build-clean-docs.sh
```

And in order to create an interactive session (web-server hosted in your local machine), you can execute the
following command

```shell
./scripts/interactive-rebuild-docs.sh
```

Remark: In order to execute a bash script with a Windows OS, it is recommended to use a bash terminal emulator

## Hugging Face

See instructions at https://huggingface.co/welcome

Install `huggingface_hub` into the poetry project.

```shell
poetry add --group=dev huggingface_hub
```

On MacOS, you might probably want to install `hugginface-cli` from brew :
```shell
$ brew install huggingface-cli
```

In order to deploy the streamlit app you will have to export
the poetry config as a `requirements.txt` :
```shell
$ poetry export -o ../requirements.txt --without-hashes --only main
```
