import gradio as gr
import time

from transformers import AutoTokenizer, AutoModelForCausalLM
import textwrap
import re

tokenizer = AutoTokenizer.from_pretrained("AnthonyErosion/HoctotAI")
model = AutoModelForCausalLM.from_pretrained("AnthonyErosion/HoctotAI",device_map='auto',load_in_8bit=False)

main_theme = gr.Theme.from_hub("gstaff/xkcd")

with gr.Blocks(theme=main_theme) as MainChatbot:
    verify_text = lambda txt : '\n'.join([textwrap.fill(txt, width=150) for txt in txt.split('\n')])
    
    def conver_inp(text:str):
      return f"<|prompter|> {text} <|endoftext|><|assistant|>"
    
    def generate(text,max_new_tokens:int=1024,use_conver:bool=False,b_pair=False):
      text = conver_inp(text) if use_conver else text
    
      for i in range(max_new_tokens):
        enc = tokenizer(text,return_tensors='pt',add_special_tokens=False)
        text_r = text
        enc = model.generate(enc.input_ids,max_new_tokens=1,pad_token_id=0)
        text = tokenizer.decode(enc[0],skip_special_tokens=False)
        text = text[:-4]+tokenizer.eos_token if text[-4:] == '\n\n\n\n' else text
      
        if text.endswith(tokenizer.eos_token) or text.endswith('\n\n\n\n\n'):
          yield text[len(text_r):] if b_pair else text
          break
        else:
          yield text[len(text_r):] if b_pair else text
    
    chatbot = gr.Chatbot()
    msg = gr.Textbox(
            show_label=False,
            placeholder="Nhập tin nhắn và bấm Enter để nhận phản hồi... ⌨️",
        ).style(container=False)
    
    def respond(message, chat_history):
        bot_message = ""
        chat_history.append((message, bot_message))
        for v in generate(message,1024,True):
            bot_message = re.sub(r"<\|prompter\|>.*?<\|endoftext\|>", "", v)
            bot_message = bot_message.replace("<|assistant|>", "").replace("<|endoftext|>", "").strip()
            bot_message = verify_text(bot_message)
            chat_history[-1] = [message, bot_message]
            yield "", chat_history
        time.sleep(1)
    msg.submit(respond, [msg, chatbot], [msg, chatbot])
MainChatbot.launch()
