import gradio as gr
from fastai.vision.all import *
from efficientnet_pytorch import EfficientNet 

import torch, torchvision
from torchvision import transforms
from pytorch_grad_cam import GradCAM
from pytorch_grad_cam.utils.image import show_cam_on_image
from PIL import Image

title = "COVID_19 Infection Detectation App!"
head = (  
    "<body>"
        "<center>"
            "<img src='/file=Gradcam.png' width=200>"
            "<h2>"
                "This Space demonstrates a model based on efficientnetB7 base model. The Model was trained to classify chest xray image. To test it, "
            "</h2>"
            "<h3>"
                "Use the Example Images provided below the up or Upload your own xray images with the App." 
            "</h3>"
            "<h3>"
                "!!!PLEASE NOTE MODEL WAS TRAINED and VALIDATED USING PNG FILES!!!" 
            "</h3>"
    "</center>"
            "<p>"
                "<b>""<a href='https://www.kaggle.com/datasets/anasmohammedtahir/covidqu'>The model is trained using COVID-QU-Ex dataset</a>""</b>"
                "  that the researchers from Qatar University compiled. THe Dataset consists of 33,920 chest X-ray (CXR) images:"
            "</p>"
            "<ul>"
              "<li>" 
                    "11,956 COVID-19"
              "</li>"    
              "<li>" 
                    "11,263 Non-COVID infections (Viral or Bacterial Pneumonia)"
              "</li>"     
              "<li>" 
                    "10,701 Normal"
              "</li>"     
            "</ul>"
            "<p>"
                "Thanks to Kaggle & KaggleX, this is the largest ever created lung xray dataset, that I am aware of, publicly available as of October 2023."
            "</p>"
    "</body>"
)
description = head

examples = [
    ['covid/covid_1038.png'], ['covid/covid_1034.png'], 
    ['covid/cd.png'], ['covid/covid_1021.png'], 
    ['covid/covid_1027.png'], ['covid/covid_1042.png'], 
    ['covid/covid_1031.png']
]

#learn = load_learner('model/predictcovidfastaifinal18102023.pkl')
learn = load_learner('model/final_20102023_eb7_model.pkl')

categories = learn.dls.vocab

def predict_image(get_image):
   pred, idx, probs = learn.predict(get_image)
   return dict(zip(categories, map(float, probs)))

interpretation= 'shap'
enable_queue=True

gr.Interface(fn=predict_image, inputs=gr.Image(shape=(224,224)),
             outputs = gr.Label(num_top_classes=3),title=title,description=description,examples=examples, interpretation=interpretation,enable_queue=enable_queue).launch(share=False)

