import gradio as gr
from gradio.components import Markdown as md

from generate_ssrl import synthesize_audio

import os

def predict(image):
    synthesize_audio(image)
    path = os.path.join(os.path.dirname(__file__), "SSRL_Media/Designed_Audio/generated_audio.wav")
    return path

demo = gr.Blocks()

drawing_board = gr.Image(source="canvas", tool="color-sketch", shape = [405, 249])

audio_output = gr.Audio(os.path.join(os.path.dirname(__file__), "SSRL_Media/Designed_Audio/generated_audio.wav"), label="Composed Music")

demo_interface = gr.Interface(
    predict, 
    inputs = [drawing_board],
    outputs = [audio_output]
)

with gr.Blocks() as demo: 
    
    gr.Markdown(
        """
    <center>
    <h1>A Tool for Composing Music via Graphic Scores in the style of György Ligeti's Artikulation using Self-supervised Representation Learning</h1>
    </center>
    <left>
    <h4>Draw a graphic score in the style of the examples below and click on submit to generate your musical composition based on your drawing!</h4>
    <h4>Here is the YouTube link to Gyorgy Ligeti's Artikulation following its graphic score which is designed by Rainer Wehinger: <a href="https://www.youtube.com/watch?v=71hNl_skTZQ">https://www.youtube.com/watch?v=71hNl_skTZQ</a></h4>
    <h4>Please check our paper <a href="https://bit.ly/3Yv6qJy">here</a> for more details. Berker Banar and Simon Colton, 2023. </h4>
    </left>
    <center>
        <img src="https://huggingface.co/spaces/AnonymousForSubmission/Graphic_Score_and_Audio/resolve/main/graphic_score_examples.png" alt="Graphic_Score" width = "1727">
    </center>
    """
    )

    with gr.Row():
        with gr.Column(scale=1):
            drawing_board
        with gr.Column(scale=4):
            audio_output
    demo_interface.render()

if __name__ == "__main__":
    demo.launch()
