import requests

class Gofile:
    def __init__(self, token = None, folder_id= None):
        self.token = token
        self.folder_id = folder_id
        
    def find_server(self):
        resp = requests.get('https://api.gofile.io/getServer')
        result = resp.json()
        return result['data']['server']
    
    def upload(self, files):
        server = self.find_server()
        url = f'https://{server}.gofile.io/uploadFile'
        data_payload = {'token': self.token, 'folderId': self.folder_id}
        download_link = []
        for file in files:
            with open(file, 'rb') as f:
                resp = requests.post(url, files = {'file': f}, data= data_payload)
                print('upload status: ', resp.status_code)
                download_page = resp.json()['data']['downloadPage']
                download_link.append(download_page)
                print('download page: ',download_page)
        return download_link