from cProfile import label
from distutils.log import debug
from random import choices
import gradio as gr
import re
import requests
import os
import shutil
import gofile
import json
import time


try: os.mkdir('images')
except: print('images dir might already exist...')


def download_local(url):
    resp = requests.get(url, allow_redirects=True)    
    filename, file_extension = os.path.splitext(url)
    filename = os.path.basename(url)
    if file_extension == '':
        filename = filename+'.jpg'
        
    filename = 'images/{}_{}'.format(int(time.time()), filename)
    with open(filename, 'wb') as handler:
        handler.write(resp.content)
    return filename


def download(text, is_upload):
    pattern = '(?:(?:https?|ftp):\/\/)?[\w/\-?=%.]+\.[\w/\-&?=%.]+'
    print(text)
    print('upload?: ',is_upload)

    urls = re.findall(pattern, text)
    print(f'{len(urls)} urls')

    if len(urls) == 0 :
        return 'No Url Found'

    err_msgs = []

    #downloading all files 
    print('downloading...')    
    for i, url in enumerate(urls):
        try:
            download_local(url)
            if i % int(len(urls) * 0.1) == 0:
                print(f'>>> {i} files downloaded')
        except Exception as e :
            err_msgs.append(f'error downloading: {url} - {str(e)}')

    #zipping 
    print('zipping images...')
    shutil.make_archive('images', 'zip', 'images')    
    
    result =  '{} link found, {}'.format(len(urls), " ,\n ".join(err_msgs))

    if is_upload == 'yes':
        print('uploading...')
        download_links = gofile.Gofile().upload(["images.zip"])
        result += f'download link : {" ".join(download_links)}'

    return "images.zip", result

iface = gr.Interface(fn=download, 
                    inputs=["text",gr.Radio(choices=['yes','no'], label='Upload to Gofile? (slow process)')], 
                    outputs=["file", "text"])
iface.launch(debug=True)