from sentiment_wrapper import PredictionModel
import gradio as gr

model = PredictionModel()


def predict(text:str):
    result = model.predict([text])[0]
    return f'class: {result}'

markdown_text = '''
<br>
<br>

This space provides a gradio demo and an easy-to-run wrapper of the pre-trained model for fine-grained sentiment analysis in Norwegian language, pre-trained on the [NoReC dataset](https://github.com/ltgoslo/norec).

Information about project you an fine on the website of [University of Oslo](https://www.mn.uio.no/ifi/english/research/projects/sant/)

The model can be easily used for predicting sentiment as follows: 
```python
>>> from sentiment_wrapper import PredictionModel
>>> model = PredictionModel()
>>> model.predict(['vi liker svart kaffe', 'jeg elsker virkelig røde roser!'])
[5,5]
```
'''

with gr.Blocks() as demo:
    with gr.Row(equal_height=False) as row:
        text_input = gr.Textbox(label="input")
        text_output = gr.Textbox(label="output")
    with gr.Row(scale=4) as row:
        text_button = gr.Button("submit").style(full_width=True)

    text_button.click(fn=predict, inputs=text_input, outputs=text_output)
    gr.Markdown(markdown_text)


demo.launch()
