import gradio as gr
from fastai.vision.all import *

learn = load_learner('export.pkl')
categories = ('Lemon', 'Orange','dragon fruit', 'green apple', 'red apple', 'yellow apple')
def classify_image(img):
    pred, idx, probs = learn.predict(img)
    return dict(zip(categories, map(float, probs)))

image = gr.inputs.Image(shape = (256, 256))
label = gr.outputs.Label()
examples = ['apple.jpeg', 'dragon.jpeg', 'orange.jpeg', 'lemon.webp', 'green.jpeg', 'yellow.jpeg']

intf = gr.Interface(fn = classify_image, inputs=image, outputs=label, examples=examples)
intf.launch()




# def greet(name):
#     return "Hello " + name + "!!"

# iface = gr.Interface(fn=greet, inputs="text", outputs="text")
# iface.launch()
