import gradio as gr
import openai
import os

openai.api_key = os.getenv("OPENAI_API_KEY")


def generate_response(text):
    prompt = f"Code generation:\n\n```python\n{text}\n```"
    response = openai.Completion.create(
      model=gpt-3.5-turbo,
      prompt=prompt,
      max_tokens=3000,
      n=1,
      stop=None,
      temperature=0.2,
    )
    message = response.choices[0].text.strip()
    return message

iface = gr.Interface(
    fn=generate_response,
    inputs=gr.inputs.Textbox(label="Enter your code here"),
    outputs=gr.outputs.Textbox(label="Chatbot's response"),
    title="WizApp Code Generation",
    description="Use AI to generate code based on your input",
    theme="default"
)

if __name__ == "__main__":
    iface.launch()
