import gradio as gr
import os
import sys
from pathlib import Path

models = [
    {"name": "Anything 5.0", "url": "stablediffusionapi/anything-v5"},
    {"name": "Counterfeit 2.0", "url": "gsdf/Counterfeit-V2.0"},
    {"name": "Counterfeit 3.0", "url": "stablediffusionapi/counterfeit-v30"},
    {"name": "Dreamlike Anime", "url": "dreamlike-art/dreamlike-anime-1.0"},
    {"name": "MeinaMix 7", "url": "Nacholmo/meinamixv7-diffusers"},
    {"name": "Openjourney 4", "url": "prompthero/openjourney-v4"},
    {"name": "OpenNiji", "url": "Korakoe/OpenNiji"},
    {"name": "Picasso Diffusion 1.1", "url": "aipicasso/picasso-diffusion-1-1"},
    {"name": "Rev Anim", "url": "stablediffusionapi/rev-anim"},
    {"name": "TMND mix", "url": "stablediffusionapi/tmnd-mix"},
    {"name": "Waifu Diffusion", "url": "hakurei/waifu-diffusion"},
    {"name": "-------- TOP MODELS -------", "url": "WarriorMama777/AbyssOrangeMix"},
    {"name": "Abyss Orange Mix 2", "url": "WarriorMama777/AbyssOrangeMix2"},
    {"name": "Anything 3.0", "url": "Linaqruf/anything-v3.0"},
    {"name": "Anything 3.1", "url": "cag/anything-v3-1"}, 
    {"name": "Anything 3X", "url": "iZELX1/Anything-V3-X"},
    {"name": "Anything 5.0", "url": "stablediffusionapi/anything-v5"},
    {"name": "Chillout App Factory","url": "stablediffusionapi/chillout-app-factory"},
    {"name": "Classic Anime", "url": "nitrosocke/classic-anim-diffusion"},
    {"name": "Cool Japan Diffusion 2.1.2", "url": "aipicasso/cool-japan-diffusion-2-1-2"},
    {"name": "Counterfeit 2.0", "url": "gsdf/Counterfeit-V2.0"},
    {"name": "Counterfeit 3.0", "url": "stablediffusionapi/counterfeit-v30"},
    {"name": "CyberPunk Anime", "url": "DGSpitzer/Cyberpunk-Anime-Diffusion"},
    {"name": "Dark Sushi Mix", "url": "stablediffusionapi/dark-sushi-mix"},
    {"name": "Dreamlike Anime", "url": "dreamlike-art/dreamlike-anime-1.0"},
    {"name": "Eimis Anime Diffusion", "url": "eimiss/EimisAnimeDiffusion_1.0v"},
    {"name": "Ghibli Diffusion", "url": "nitrosocke/Ghibli-Diffusion"},
    {"name": "GrapeFruit", "url": "iZELX1/Grapefruit"},
    {"name": "GuoFeng 3", "url": "xiaolxl/GuoFeng3"},
    {"name": "Meina Pastel", "url": "stablediffusionapi/meinapastel"},
    {"name": "MeinaMix 7", "url": "Nacholmo/meinamixv7-diffusers"},
    {"name": "Openjourney 4", "url": "prompthero/openjourney-v4"},
    {"name": "OpenNiji", "url": "Korakoe/OpenNiji"},
    {"name": "Picasso Diffusion 1.1", "url": "aipicasso/picasso-diffusion-1-1"},
    {"name": "Protogen 2.2", "url": "darkstorm2150/Protogen_v2.2_Official_Release"},
    {"name": "Protogen Infinity", "url": "darkstorm2150/Protogen_Infinity_Official_Release"},
    {"name": "Protogen X 3.4", "url": "darkstorm2150/Protogen_x3.4_Official_Release"},
    {"name": "Rev Anim", "url": "stablediffusionapi/rev-anim"},
    {"name": "TMND mix", "url": "stablediffusionapi/tmnd-mix"},
    {"name": "Waifu Diffusion", "url": "hakurei/waifu-diffusion"},
    {"name": "-------- ALL ANIME MODELS -------", "url": "WarriorMama777/AbyssOrangeMix"},
    {"name": "7 Pa", "url": "AIARTCHAN/7pa"},
    {"name": "A Certain Model", "url": "JosephusCheung/ACertainModel"},
    {"name": "A Certain Thing", "url": "JosephusCheung/ACertainThing"},
    {"name": "A Certainity", "url": "JosephusCheung/ACertainty"},
    {"name": "Abyss Hell Hero", "url": "AIARTCHAN/AbyssHellHero"},
    {"name": "Abyss Maple 3", "url": "AIARTCHAN/AbyssMapleVer3"},
    {"name": "Abyss Orange Mix 2", "url": "WarriorMama777/AbyssOrangeMix2"},
    {"name": "Abyss Orange Mix", "url": "WarriorMama777/AbyssOrangeMix"},
    {"name": "AbyssHell 3", "url": "AIARTCHAN/AbyssHellVer3"},
    {"name": "All 526 Animated", "url": "stablediffusionapi/all-526-animated"},
    {"name": "Anidosmix 3", "url": "AIARTCHAN/anidosmixV2"},
    {"name": "Anime Kawai Diffusion", "url": "Ojimi/anime-kawai-diffusion"},
    {"name": "Anireal 3D V2", "url": "circulus/sd-anireal-3d-v2"},
    {"name": "AnyLORA", "url": "kubanemil/AnyLORA"},
    {"name": "Anything 2.1", "url": "swl-models/anything-v2.1"},
    {"name": "Anything 3.0 Light", "url": "mm00/anything-v3.0-light"},
    {"name": "Anything 3.0", "url": "Linaqruf/anything-v3.0"},
    {"name": "Anything 3.1", "url": "cag/anything-v3-1"},
    {"name": "Anything 3X", "url": "iZELX1/Anything-V3-X"},
    {"name": "Anything 5.0", "url": "stablediffusionapi/anything-v5"},
    {"name": "Anything Else 4", "url": "stablediffusionapi/anythingelse-v4"},
    {"name": "Anything Else 5", "url": "stablediffusionapi/anything-v5"},
    {"name": "Arcane Diffusion", "url": "nitrosocke/Arcane-Diffusion"},
    {"name": "Archer Diffusion", "url": "nitrosocke/archer-diffusion"},
    {"name": "Asian Mix", "url": "D1b4l4p/AsianMix"},
    {"name": "Blood Orange Mix", "url": "WarriorMama777/BloodOrangeMix"},
    {"name": "Cetusmix", "url": "stablediffusionapi/cetusmix"},
    {"name": "Chillout App Factory","url": "stablediffusionapi/chillout-app-factory"},
    {"name": "Classic Anime", "url": "nitrosocke/classic-anim-diffusion"},
    {"name": "Cool Japan Diffusion 2.1.2", "url": "aipicasso/cool-japan-diffusion-2-1-2"},
    {"name": "Cosmic Babes", "url": "stablediffusionapi/cosmic-babes"},
    {"name": "Counterfeit 1.0", "url": "gsdf/counterfeit-v1.0"},
    {"name": "Counterfeit 2", "url": "gsdf/Counterfeit-V2.0"},
    {"name": "Counterfeit 2.0", "url": "gsdf/Counterfeit-V2.0"},
    {"name": "Counterfeit 3.0", "url": "stablediffusionapi/counterfeit-v30"},
    {"name": "CyberPunk Anime", "url": "DGSpitzer/Cyberpunk-Anime-Diffusion"},
    {"name": "Dark Sushi Mix", "url": "stablediffusionapi/dark-sushi-mix"},
    {"name": "Dash Sushi 25d", "url": "stablediffusionapi/dark-sushi-25d"},
    {"name": "Dreamlike Anime", "url": "dreamlike-art/dreamlike-anime-1.0"},
    {"name": "DucHaiten Anime", "url": "DucHaiten/DucHaitenAnime"},
    {"name": "Eerie Orange Mix", "url": "WarriorMama777/EerieOrangeMix"},
    {"name": "Eimis Anime Diffusion", "url": "eimiss/EimisAnimeDiffusion_1.0v"},
    {"name": "Ghibli Diffusion", "url": "nitrosocke/Ghibli-Diffusion"},
    {"name": "GrapeFruit", "url": "iZELX1/Grapefruit"},
    {"name": "GuoFeng 3", "url": "xiaolxl/GuoFeng3"},
    {"name": "Icomix 2", "url": "stablediffusionapi/icomix-2"},
    {"name": "InkPunk Diffusion", "url": "Envvi/Inkpunk-Diffusion"},
    {"name": "Mama Orange Mixs", "url": "WarriorMama777/OrangeMixs"},
    {"name": "Meina Alter", "url": "stablediffusionapi/meinaalter"},
    {"name": "Meina Pastel", "url": "stablediffusionapi/meinapastel"},
    {"name": "MeinaMix 7", "url": "Nacholmo/meinamixv7-diffusers"},
    {"name": "Mix Pro V4", "url": "AIARTCHAN/MIX-Pro-V4"},
    {"name": "NeverEnding-Dream", "url": "Lykon/NeverEnding-Dream"},
    {"name": "Openjourney 4", "url": "prompthero/openjourney-v4"},
    {"name": "OpenNiji", "url": "Korakoe/OpenNiji"},
    {"name": "Picasso Diffusion 1.1", "url": "aipicasso/picasso-diffusion-1-1"},
    {"name": "Protogen 2.2", "url": "darkstorm2150/Protogen_v2.2_Official_Release"},
    {"name": "Protogen Infinity", "url": "darkstorm2150/Protogen_Infinity_Official_Release"},
    {"name": "Protogen X 3.4", "url": "darkstorm2150/Protogen_x3.4_Official_Release"},
    {"name": "Rev Anim", "url": "stablediffusionapi/rev-anim"},
    {"name": "Rev Animated", "url": "coreml/coreml-ReV-Animated"},
    {"name": "Rev Animated", "url": "LottePeisch/RevAnimated-Diffusers"},
    {"name": "Something V 2.2","url": "NoCrypt/SomethingV2_2"},
    {"name": "Something V2","url": "NoCrypt/SomethingV2"},
    {"name": "Three Delicacy", "url": "stablediffusionapi/three-delicacy"},
    {"name": "Three Delicacy wonto", "url": "stablediffusionapi/three-delicacy-wonto"},
    {"name": "TMND mix", "url": "stablediffusionapi/tmnd-mix"},
    {"name": "Waifu Diffusion", "url": "hakurei/waifu-diffusion"}
]

current_model = models[0]

text_gen = gr.Interface.load("spaces/daspartho/prompt-extend") 

models2 = []
for model in models:
    model_url = f"models/{model['url']}"
    loaded_model = gr.Interface.load(model_url, live=True, preprocess=True)
    models2.append(loaded_model)


def text_it(inputs, text_gen=text_gen):
    return text_gen(inputs)


def set_model(current_model_index):
    global current_model
    current_model = models[current_model_index]
    return gr.update(value=f"{current_model['name']}")


def send_it(inputs, model_choice):
    proc = models2[model_choice]
    return proc(inputs)


with gr.Blocks() as myface:
    gr.HTML(

    )

    with gr.Row():
        with gr.Row():
            input_text = gr.Textbox(label="Prompt idea",  placeholder="", lines=1)
            # Model selection dropdown
            model_name1 = gr.Dropdown(
                label="Choose Model",
                choices=[m["name"] for m in models],
                type="index",
                value=current_model["name"],
                interactive=True,
            )
        with gr.Row():
            see_prompts = gr.Button("Generate Prompts")
            run = gr.Button("Generate Images", variant="primary")
    
    with gr.Row():
        output1 = gr.Image(label="")
        output2 = gr.Image(label="")
        output3 = gr.Image(label="")
    with gr.Row():
        magic1 = gr.Textbox(label="Generated Prompt", lines=2)
        magic2 = gr.Textbox(label="Generated Prompt", lines=2)
        magic3 = gr.Textbox(label="Generated Prompt", lines=2)
    with gr.Row():
        output4 = gr.Image(label="")
        output5 = gr.Image(label="")
        output6 = gr.Image(label="")
    with gr.Row():
        magic4 = gr.Textbox(label="Generated Prompt", lines=2)
        magic5 = gr.Textbox(label="Generated Prompt", lines=2)
        magic6 = gr.Textbox(label="Generated Prompt", lines=2)

    model_name1.change(set_model, inputs=model_name1, outputs=[output1, output2, output3, output4, output5, output6])

    run.click(send_it, inputs=[magic1, model_name1], outputs=[output1])
    run.click(send_it, inputs=[magic2, model_name1], outputs=[output2])
    run.click(send_it, inputs=[magic3, model_name1], outputs=[output3])
    run.click(send_it, inputs=[magic4, model_name1], outputs=[output4])
    run.click(send_it, inputs=[magic5, model_name1], outputs=[output5])
    run.click(send_it, inputs=[magic6, model_name1], outputs=[output6])

    see_prompts.click(text_it, inputs=[input_text], outputs=[magic1])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic2])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic3])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic4])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic5])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic6])

myface.queue(concurrency_count=200)
myface.launch(inline=True, show_api=False, max_threads=400)