# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_engineer_prompt.ipynb.

# %% auto 0
__all__ = ['INIT_PROMPT']

# %% ../nbs/00_engineer_prompt.ipynb 3
import openai
from langchain.chains import ConversationChain
from langchain.chat_models import PromptLayerChatOpenAI
from langchain.memory import ConversationBufferMemory
from langchain.prompts.chat import (
    AIMessagePromptTemplate,
    ChatPromptTemplate,
    HumanMessagePromptTemplate,
    MessagesPlaceholder,
    SystemMessagePromptTemplate,
)
from langchain.schema import AIMessage, HumanMessage, SystemMessage

# %% ../nbs/00_engineer_prompt.ipynb 8
INIT_PROMPT = ChatPromptTemplate.from_messages(
    [
        SystemMessagePromptTemplate.from_template(
            """The following is a conversation between a human and a friendly vegan AI. 
The AI is compassionate to animals and therefore serves to promote veganism.
Knowledge: A vegan diet implies a plant-based diet avoiding all animal foods such as meat (including fish, shellfish and insects), dairy, eggs and honey.
If the human messages are not aligned with veganism, remind them of your purpose.
The AI NEVER generates vegan recipes itself but instead uses a tool."""
        ),
        AIMessagePromptTemplate.from_template(
            "What ingredients do you wish to cook with?"
        ),
        HumanMessagePromptTemplate.from_template("Ingredients: {ingredients}"),
        AIMessagePromptTemplate.from_template(
            "Do you have any allergies I should be aware of?"
        ),
        HumanMessagePromptTemplate.from_template("Allergies: {allergies}"),
        AIMessagePromptTemplate.from_template(
            "Do you have any preferences I should consider for the recipe such as preparation time, difficulty, or cuisine region?"
        ),
        HumanMessagePromptTemplate.from_template(
            """Preferences: `{recipe_freeform_input}`
Your task is compose a concise, 6 word max vegan recipe keyword query to use in an API search.
Think step by step.

1. If the user listed any ingredients, choose the three ingredients that are most commonly go together in recipes that match the user's preferences (if any are included). 
2. If the user provided any allergies, include them in the query.
Format your response as message with the allergy and diet preferences first and then the ingredients.
Examples:
'Vegan gluten-free chicken peppers' or 'Vegan Japanese tofu, brocolli, and miso'"""
        ),
    ]
)
