from lv_recipe_chatbot.app import create_demo, ConversationBot
from lv_recipe_chatbot.ingredient_vision import (
    VeganIngredientFinder,
    BlipImageCaptioning,
)
import os


# for Hugging Face

if __name__ == "__main__":
    vegan_ingred_finder = VeganIngredientFinder()
    img_cap = BlipImageCaptioning("cpu")
    demo = create_demo(
        ConversationBot(
            vegan_ingred_finder=vegan_ingred_finder, img_cap=img_cap, verbose=True
        )
    )
    demo.launch(
        auth=(os.environ["GRADIO_DEMO_USERNAME"], os.environ["GRADIO_DEMO_PASSWORD"])
    )
