---
title: lv-recipe-chatbot
emoji: 🫑
colorFrom: green 
colorTo: indigo
sdk: gradio
sdk_version: 3.23.0
app_file: app.py
pinned: false
license: unknown
---
# lv-recipe-chatbot

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

``` sh
pip install -e '.[dev]'
```

## How to use

``` python
from dotenv import load_dotenv

load_dotenv()  # or load environment vars with different method

demo = app.create_demo(app.ConversationBot())
demo.launch()
```

    Running on local URL:  http://127.0.0.1:7860

    To create a public link, set `share=True` in `launch()`.

<div><iframe src="http://127.0.0.1:7860/" width="100%" height="500" allow="autoplay; camera; microphone; clipboard-read; clipboard-write;" frameborder="0" allowfullscreen></iframe></div>

or

``` sh
python3 app.py
```

## Dev quick-start

`git clone` the repo

``` sh
cd lv-recipe-chatbot
```

Make sure to use the version of python specified in `py_version.txt`  
Create a virtual environment.

``` sh
python3 -m venv env
```

Activate the env and install dependencies.

``` sh
source env/bin/activate
pip install -r requirements.txt
pip install -r requirements/dev.txt
```

To make the Jupyter environment, git friendly: `nbdev_install_hooks`  
If you want to render documentation locally, you will want to [install
Quarto](https://nbdev.fast.ai/tutorials/tutorial.html#install-quarto).

`nbdev_install_quarto`

Put API secrets in .env

``` sh
cp .env.example .env
```

Edit .env with your secret key(s). Only `OPEN_AI_KEY` is required.

Then start the Gradio demo from within the virtual environment.

``` sh
python3 app.py
```

Preview documentation

``` sh
nbdev_preview
```

## Dependencies

If a new dependency for development is helpful for developers, add it to
`dev.txt`.  
If it is a dependency for the app that is imported in source code, add
it to `core.txt`.  
Then run:

``` sh
scripts/pin_requirements.sh
```

This will update our `requirements.txt` to include the dependency as it
should be pinned in the environment.

## Development

[quick nbdev tutorial](https://nbdev.fast.ai/tutorials)

Make changes in `/nbs`.  
Update the package files with `nbdev_export` then reimport with
`pip install -e '.[dev]'`

Preview doc `nbdev_preview`  
Build docs, test and update README `nbdev_prepare`

## Useful links

- [Task Matrix (Formerly Visual
  ChatGPT)](https://github.com/microsoft/TaskMatrix)
- [LangChain](https://python.langchain.com/en/latest/index.html)
- [LLM Prompt Engineering](https://www.promptingguide.ai)
- [OpenAI best practices for
  prompts](https://help.openai.com/en/articles/6654000-best-practices-for-prompt-engineering-with-openai-api)
