import gradio as gr
from joblib import load
import pandas as pd
from sklearn.svm import SVC
import tensorflow as tf
from tensorflow import keras
from tensorflow.keras import layers
import numpy as np 
import streamlit as st
import matplotlib.pyplot as plt



model = load('Red_nueronal_morosidad.joblib')


def run_my_model(Var_Trim_TIIE_91,Var_Trim_FIX,Var_Trim_PIB):
    X_new = (Var_Trim_TIIE_91,Var_Trim_FIX,Var_Trim_PIB)
    Y_pred = str(4.84 +(1+float(model.predict(np.array([X_new])))))
    return "Estimación de tasa de tasa de incumplimiento: " + Y_pred

theme = "darkgrass"
interface = gr.Interface(
    fn = run_my_model,
    inputs = [
        gr.inputs.Slider(minimum = -10, maximum = 30),
        gr.inputs.Slider(minimum = -10, maximum = 10),
        gr.inputs.Slider(minimum = -10, maximum = 10)
     ],
    datatype = ['number','number','number'],
    outputs = "text",
    live = True,
    title = "Predicción de Tasa de Incumplimiento",
    css = """
   body{background-color:aliceblue} 
  """ 

)

interface.launch(inbrowser = True)
    
    
    