import gradio as gr

from assets.content import TITLE, INTRODUCTION_TEXT
from assets.path import SEASON


def create_top():
    gr.HTML(TITLE)
    gr.Markdown(INTRODUCTION_TEXT, elem_classes="markdown-text")
    with gr.Row():
        season_dropdown = gr.Dropdown(choices=list(SEASON), value="latest", label="Season Select")
        language_dropdown = gr.Dropdown(choices=['en', 'zh'], value='en', label='Language Select')
    return {"season": season_dropdown, "language": language_dropdown}
