import json
import os

import gradio as gr
import pandas as pd

from assets.constant import DELIMITER
from assets.content import KEYPOINT_TEXT, QUESTION_TEXT
from assets.path import SEASON


def build_question(season):
    dir = os.path.join("results", SEASON[season], "details")
    rows = []
    for model in os.listdir(dir):
        acc_result = json.load(open(os.path.join(dir, model, "acc_result.json"), encoding="utf-8"))
        rows.append(
            [model, round(acc_result['acc'], 4), round(acc_result['human_acc'], 4), round(acc_result['wrong_value'], 4),
             acc_result['hit'],acc_result['wrong_hit'], acc_result['wrong_total'], acc_result['total']])
    return pd.DataFrame(rows, columns=["Model", "Acc", "Human Acc", "Wrong Value", "Hit", "Wrong Hit", "Wrong Total",
                                       "Total"]).sort_values("Acc", ascending=False)


def build_keypoint(season):
    dir = os.path.join("results", SEASON[season], "details")
    rows, columns, final_columns = [], [], []
    for model in os.listdir(dir):
        category_result = json.load(open(os.path.join(dir, model, "category_result.json"), encoding="utf-8"))
        if not columns:
            columns = sorted([k for k in category_result if not k.count(DELIMITER)],
                             key=lambda x: category_result[x]['all'], reverse=True)
            final_columns = [f"{c}:{category_result.get(c).get('all')}" for c in columns]
        rows.append([model] + [round(category_result.get(c).get("acc"), 4) for c in columns])
    return pd.DataFrame(rows, columns=["Model"] + final_columns).sort_values(final_columns[0], ascending=False)


def build_difficulty(season):
    dir = os.path.join("results", SEASON[season], "details")
    rows, columns, final_columns = [], [], []
    for model in os.listdir(dir):
        difficulty_result = json.load(open(os.path.join(dir, model, "difficulty_result.json"), encoding="utf-8"))
        if not columns:
            columns = sorted(difficulty_result, reverse=True)
            final_columns = [f"{c}:{difficulty_result.get(c).get('all')}" for c in columns]
        rows.append([model] + [round(difficulty_result.get(c).get("acc"), 4) for c in columns])

    return pd.DataFrame(rows, columns=["Model"] + final_columns).sort_values(final_columns[0], ascending=False)


def create_result(top_components):
    with gr.Tab("Question Level"):
        gr.Markdown(QUESTION_TEXT)
        question_df = gr.DataFrame(build_question("latest"), label="Acc Result")
    with gr.Tab("Keypoint Level"):
        gr.Markdown(KEYPOINT_TEXT)
        keypoint_df = gr.DataFrame(build_keypoint("latest"), label="Keypoint Level1 Result")
    with gr.Tab("Difficulty Level"):
        difficulty_df = gr.DataFrame(build_difficulty("latest"), label="Difficulty Result")
