import gradio as gr

from components.about import create_about
from components.detail import create_detail
from components.submit import create_submit
from components.top import create_top
from components.data import create_data
from components.result import create_result

with gr.Blocks(title="Ango Leaderboard") as app:
    top_components = create_top()
    with gr.Tab("Result"):
        create_result(top_components)
    with gr.Tab("Details"):
        create_detail(top_components)
    with gr.Tab("Data"):
        create_data(top_components)
    with gr.Tab("Submit"):
        create_submit()
    with gr.Tab("About"):
        create_about()

app.queue()
app.launch()
