import numpy as np
import pandas as pd
import joblib
import streamlit as st

with open('pipeline_clf.pkl', 'rb') as file_1:
  clf = joblib.load(file_1)

st.title('Prediksi Resiko Penyakit Diabetes')
umur = st.number_input('Umur Saat Ini :', 18, 100)
if (umur >= 18) & (umur <= 24):
    Age = 1
elif (umur >= 25) & (umur <= 34):
    Age = 2
elif (umur >= 35) & (umur <= 44):
    Age = 3
elif (umur >= 45) & (umur <= 54):
    Age = 4
elif (umur >= 55) & (umur <= 64):
    Age = 5
elif (umur >= 65) & (umur <= 74):
    Age = 6
elif (umur >= 75) :
    Age = 7

tinggi_badan = st.number_input('Masukkan Tinggi Badan(cm) Anda :', 1,250)
berat_badan = st.number_input('Masukkan Berat Badan(Kg) Anda :', 1,200)
BMI = berat_badan/((tinggi_badan/100)**2)

Kolestrol = st.radio('Apakah Anda Memiliki Riwayat Kolestrol Tinggi ?', ('Tidak', 'Ya'))
if Kolestrol == 'Tidak':
    HighChol = 0
else:
    HighChol = 1 

Penyakit_Jantung = st.radio('Apakah Anda Memiliki Riwayat Penyakit Jantung ?', ('Tidak', 'Ya'))
if Penyakit_Jantung == 'Tidak':
    HeartDiseaseorAttack = 0
else:
    HeartDiseaseorAttack = 1

Tensi = st.radio('Apakah Anda Memiliki Riwayat Hipertensi ?', ('Tidak', 'Ya'))
if Tensi == 'Tidak':
    HighBP = 0
else:
    HighBP = 1
    
Jalan = st.radio('Apakah Anda Memiliki Kesulitan Berjalan ?', ('Tidak', 'Ya'))
if Jalan == 'Tidak':
    DiffWalk = 0
else:
    DiffWalk = 1

kesehatan = st.selectbox('Bagaimana Kondisi Kesehatan Anda Secara Umum ?', ('Luar Biasa', 'Sangat Baik', 'Baik', 'Kurang Baik', 'Jelek'))
if kesehatan == 'Luar Biasa':
    GenHlth = 1
elif kesehatan == 'Sangat Baik':
    GenHlth = 2
elif kesehatan == 'Baik':
    GenHlth = 3
elif kesehatan == 'Kurang Baik':
    GenHlth = 4
elif kesehatan == 'Jelek':
    GenHlth = 5

if st.button('Prediksi'):
    data_inf = pd.DataFrame({'Age' : Age,
                             'BMI' : BMI,
                             'HighChol' : HighChol,
                             'HeartDiseaseorAttack' : HeartDiseaseorAttack,
                             'HighBP' : HighBP,
                             'DiffWalk' : DiffWalk,
                             'GenHlth' : GenHlth
                             },index=[0])
    hasil = 'Anda Tidak Memiliki Resiko Diabetes' if clf.predict(data_inf) == 0 else 'Anda Beresiko Diabetes'
    st.header(hasil)