# load required libraries

import streamlit as st
import spacy
#import en_core_web_sm
from numerizer import numerize


st.title("Numerizer - Convert *English Numbers* into *Ints* and *Floats*")

@st.cache(allow_output_mutation=True, suppress_st_warning=True)
def load_model():
    """Load a spaCy model."""
    model = spacy.load("en_core_web_sm")
    return model


@st.cache(allow_output_mutation=True, suppress_st_warning=True)
def process_text(text: str):
    """Process a text and create a Doc object."""
    nlp = load_model()
    return nlp(text)

st.markdown("Input Text")

inp_text = st.text_input(label="Add text here", value = "Two plus Two equals Four")
#inp_text = 'The Hogwarts Express is at platform nine and three quarters and platform nine and three quarters'

st.write(inp_text)

doc = process_text(inp_text)


numerized_parts = doc._.numerize()

st.markdown("Numerized Sections \n")

st.markdown( numerized_parts)


final_sentence = inp_text

for key in numerized_parts.keys():
    #print(key)
    final_sentence = final_sentence.replace(str(key),numerized_parts[key])

st.write("### Numerized Output Text")

st.write(final_sentence)
