from fastai.vision.all import *
import gradio as gr

def is_classical(x): return x[0].isupper()

# Cell
learn = load_learner('interior.pkl')

# Cell
categories = ('classical','japandi','minimal','poho','earthy')

def classify_image(img):
    pred,idx,probs = learn.predict(img)
    return dict(zip(categories, map(float,probs)))

# Cell
image = gr.inputs.Image(shape=(192, 192))
label = gr.outputs.Label()
examples = ['classical.jpg','japandi.jpg','minimal.jpg','poho.jpg','earthy.jpg']

intf = gr.Interface(fn=classify_image, inputs=image, outputs=label, examples=examples)
intf.launch()