# This is a sample Python script.

# Press Shift+F10 to execute it or replace it with your code.
import os.path
import pandas as pd
import glob
import os

sn = "S/N"
ipp = "IPPIS"
gif = "GIFMIS"
col_1 = "BENEFICIARY NAME"
gif_col = [col_1, "Employee", "Rank", "Amount"]
ipp_col = ["Employee Number", "Full Name", "Grade Level", "Step", "Grosss Deductions SUM 1"]


def get_raw(link, sheet, file_ext='.xlsx'):
    match file_ext:
        # handle testing files
        case '.csv':
            return pd.read_csv(link)

        case '.xlsx' | '.xls':
            return pd.read_excel(link, sheet_name=sheet)

        case _:
            return UnusualFileError(link, "Invalid file extension")


def get_data(link, sheet, doc_type=ipp, file_type='.csv'):
    match file_type:
        # handle testing files
        case '.csv':
            return pd.read_csv(link)

        # handle GIFMIS files
        case '.xlsx' | '.xls' if doc_type == gif:

            try:
                data = pd.read_excel(link, sheet_name=sheet, skiprows=3, header=0)
                return data.drop(data.columns.difference(gif_col), axis=1)
            except ValueError as err:
                raise UnusualFileError(link, str(err))
            except KeyError:
                return None

        # handle IPPIS files
        case '.xlsx' | '.xls' if doc_type == ipp:

            try:
                data = pd.read_excel(link, sheet_name=sheet, skiprows=4, header=0)
                return data.drop(data.columns.difference(ipp_col), axis=1)
            except ValueError as err:
                raise UnusualFileError(link, str(err))
            except KeyError:
                return None

        # default
        case _:
            return None


def merge_two(first: pd.DataFrame, second: pd.DataFrame, doc_type):
    hows = ['inner', 'left', 'right']
    first = first.drop(sn, axis=1, errors="ignore")
    second = second.drop(sn, axis=1, errors="ignore")

    both, prev, curr = tuple(
        [first.merge(second, how=how, on=first.columns[0] if doc_type == ipp else first.columns[1]) for how in hows]
    )

    prev = prev[
        prev[
            prev.columns[5] if doc_type == ipp else prev.columns[4]  # Get rows where name column is empty
        ].isnull()
    ].dropna(subset=[
        prev.columns[0] if doc_type == ipp else prev.columns[1]  # Check for empty rows in the employee number column
    ]).dropna(axis=1, how="all")  # Remove empty columns

    curr = curr[
        curr[
            curr.columns[1] if doc_type == ipp else curr.columns[0]  # Get rows where name column is empty
        ].isnull()
    ].dropna(subset=[
        curr.columns[0] if doc_type == ipp else curr.columns[1]  # Check for empty rows in the employee number column
    ]).dropna(axis=1, how="all")  # Remove empty columns

    return both, prev, curr


def merge_all(data_list, keys=tuple("Employee")):
    return pd.concat(
        [data.drop(sn, axis=1, errors="ignore") for data in data_list],
        axis=1,
        join='inner',
        keys=keys,
        ignore_index=True
    )


def retrieve(dt):
    return get_data(dt.name, os.path.splitext(dt.name)[1])


def clear_csv_trash():
    pattern = '*.csv'  # Desired file pattern

    # Get a list of file paths matching the pattern
    matching_files = glob.glob(pattern)

    # Loop through the matching files and delete them
    for file_path in matching_files:
        try:
            os.remove(file_path)
        except OSError as e:
            print(f"Error deleting {file_path}: {e}")


class UnusualFileError(Exception):
    def __init__(self, file, message):
        self.source = file
        self.cause = message

    def __str__(self):
        from numpy.core._dtype import __repr__
        return __repr__(self.source)

    def get_file(self):
        return self.source

    def get_message(self):
        return self.cause
