# This is a sample Python script.

# Press Shift+F10 to execute it or replace it with your code.
import gradio as gr
from utils import *
from datetime import datetime

doc_type = ipp
prev_sht = None
curr_sht = None


def ui_builder():
    with gr.Blocks() as demo:
        err_view = gr.Textbox(label="Error found", visible=False)

        with gr.Tab("Multiple files"):

            def generate_all(d):
                try:
                    d = [retrieve(dt) for dt in d if retrieve(dt) is not None]

                    out = "All months.csv"

                    merge_all(d).to_csv(out)

                    return {
                        err_view: gr.update(visible=False),
                        out_file: gr.update(value=out, visible=True, label="Merged file")
                    }
                except TypeError:
                    return {
                        err_view: gr.update(
                            value="Please select a folder containing all the files you want to filter",
                            visible=True
                        ),
                        out_file: gr.update(visible=False)
                    }

            # input ui
            gr.Markdown('### See data that shows up in every month file in the chosen folder')
            all_data = gr.File(label="Add a folder with all months", file_count="directory")

            # output ui
            output = gr.Markdown("## *Download your file", visible=False)
            out_file = gr.File(value="Tutorial Guide.pdf", label="Learn to use this app", visible=True)
            run = gr.Button("Generate file")

            run.click(fn=generate_all, inputs=all_data, outputs=[err_view, out_file])
        with gr.Tab("Compare two"):

            def err_str(err):
                f"""\
[Faulty file]
    Check ••••• {
                os.path.split(
                    os.path.splitext(
                        err.get_file()
                    )[0]
                )[1][:-8]
                }

        {err.get_message()}\
"""

            def raise_error(msg: str) -> dict:
                return {
                    err_view: gr.update(
                        value=msg,
                        visible=True
                    ),
                    b: gr.update(visible=False),
                    f: gr.update(visible=False),
                    s: gr.update(visible=False),
                    prev_dis: gr.update(value=None),
                    curr_dis: gr.update(value=None),
                    files: gr.update(visible=False)
                }

            def choose_type(event: gr.SelectData):
                global doc_type
                doc_type = event.value
                return {
                    uploads: gr.update(visible=True)
                }

            def check_prev(pr):
                try:
                    shts = pd.ExcelFile(pr.name).sheet_names

                    return {
                        prev_sheet: gr.update(choices=shts),
                        sheets: gr.update(visible=True)
                    }
                except UnusualFileError as err:
                    return raise_error(err_str(err))

            def check_curr(cr):
                try:
                    shts = pd.ExcelFile(cr.name).sheet_names

                    return {
                        curr_sheet: gr.update(choices=shts),
                        sheets: gr.update(visible=True)
                    }
                except UnusualFileError as err:
                    return raise_error(err_str(err))

            def sheet_prev(event: gr.SelectData, file):
                global prev_sht
                prev_sht = event.value
                name, ext = os.path.splitext(file.name)
                pr = get_raw(file.name, prev_sht, ext)
                return {
                    data: gr.update(visible=True),
                    outputs: gr.update(visible=True),
                    prev_dis: gr.update(value=pr)
                }

            def sheet_curr(event: gr.SelectData, file):
                global curr_sht
                curr_sht = event.value
                name, ext = os.path.splitext(file.name)
                cr = get_raw(file.name, curr_sht, ext)
                return {
                    data: gr.update(visible=True),
                    outputs: gr.update(visible=True),
                    curr_dis: gr.update(value=cr)
                }

            def generate(p, c, b_i, f_i, s_i):
                current_time = datetime.now()
                formatted_time = current_time.strftime('• %d-%m-%Y • %H.%M.%S')
                b_file, f_file, s_file = f"Present in both {formatted_time}.csv", f"Exits {formatted_time}.csv", \
                                         f"Entries {formatted_time}.csv"
                # extract info from UI results
                try:
                    p_name, p_ext = os.path.splitext(p.name)
                    c_name, c_ext = os.path.splitext(c.name)
                    p = get_data(p.name, prev_sht, doc_type, p_ext)
                    c = get_data(c.name, curr_sht, doc_type, c_ext)

                    # process the data
                    if p is None or c is None:
                        return raise_error(f"Incompatible column names in either or both files. Make sure they "
                                           f"conform to the standard.\n\nIPPIS: {ipp_col}\nGIFMIS: {gif_col}")
                    elif p.columns[0] != c.columns[0]:
                        return raise_error(f"You seem to be mixing {ipp} and {gif} files. This is not allowed")
                    else:
                        both_, p_merged, c_merged = merge_two(p, c, doc_type)

                    clear_csv_trash()

                    # save only the files the user requested
                    if b_i:
                        both_.to_csv(b_file, index=False)

                    if f_i:
                        p_merged.to_csv(f_file, index=False)

                    if s_i:
                        c_merged.to_csv(s_file, index=False)

                    return {
                        err_view: gr.update(visible=False),
                        b: gr.update(value=b_file, visible=True) if b_i else gr.update(visible=False),
                        f: gr.update(value=f_file, visible=True) if f_i else gr.update(visible=False),
                        s: gr.update(value=s_file, visible=True) if s_i else gr.update(visible=False),
                        prev_dis: gr.update(value=p),
                        curr_dis: gr.update(value=c),
                        files: gr.update(visible=True) if b_i or f_i or s_i else gr.update(visible=False)
                    }
                except AttributeError:
                    return raise_error("Please select both files below before generating files")
                except UnusualFileError as err:
                    return raise_error(err_str(err))

            # input ui
            with gr.Blocks():
                ########################################################################################################
                type = gr.Radio([ipp, gif], label="Type", info="Choose a file type")
                ########################################################################################################
                with gr.Row(visible=False) as uploads:
                    prev = gr.File(label="Previous month", file_types=['.csv', '.xls', '.xlsx'])
                    curr = gr.File(label="Current month", file_types=['.csv', '.xls', '.xlsx'])
                ########################################################################################################
                with gr.Row(visible=False) as sheets:
                    prev_sheet = gr.Radio(["N/A"], label="Sheets", info="Which sheet do you want to use?",
                                          interactive=True)
                    curr_sheet = gr.Radio(["N/A"], label="Sheets", info="Which sheet do you want to use?",
                                          interactive=True)
                ########################################################################################################
                with gr.Row(visible=False) as data:
                    prev_dis = gr.Dataframe(row_count=(5, "fixed"), col_count=(5, "fixed"), interactive=False)
                    curr_dis = gr.Dataframe(row_count=(5, "fixed"), col_count=(5, "fixed"), interactive=False)
                ########################################################################################################
                with gr.Column(visible=False) as outputs:
                    both = gr.Checkbox(label="See data that shows up in both months")
                    first = gr.Checkbox(label="See data that's in the previous month but not in the current")
                    second = gr.Checkbox(True, label="See data that's in the current month but not in the previous")
                ########################################################################################################
            # output ui
            with gr.Blocks():
                output = gr.Markdown("## *Download your files", visible=False)
                with gr.Row(visible=False) as files:
                    b = gr.File(label="Both months", visible=False)
                    f = gr.File(label="Previous month", visible=False)
                    s = gr.File(label="Current month", visible=False)
                run = gr.Button("Generate files")

                type.select(fn=choose_type, inputs=None, outputs=[uploads])
                prev.upload(fn=check_prev, inputs=[prev], outputs=[prev_sheet, sheets])
                curr.upload(fn=check_curr, inputs=[curr], outputs=[curr_sheet, sheets])
                prev_sheet.select(fn=sheet_prev, inputs=[prev], outputs=[data, outputs, prev_dis])
                curr_sheet.select(fn=sheet_curr, inputs=[curr], outputs=[data, outputs, curr_dis])
                run.click(fn=generate, inputs=[prev, curr, both, first, second], outputs=[err_view, b, f, s, prev_dis,
                                                                                          curr_dis, files])
    demo.launch()


# Press the green button in the gutter to run the script.
if __name__ == '__main__':
    ui_builder()

# See PyCharm help at https://www.jetbrains.com/help/pycharm/
