from fastai.vision.all import *
import gradio as gr


# Cargamos el learner
learn = load_learner('export.pkl')

# Definimos las etiquetas de nuestro modelo
#labels = learn.dls.vocab


# Definimos una función que se encarga de llevar a cabo las predicciones
def predict(img):
    img = PILImage.create(img)
    pred = learn.predict(img)[0]
    return pred
 

    
# Creamos la interfaz y la lanzamos. 
gr.Interface(fn=predict, inputs=gr.inputs.Image(shape=(128, 128)), outputs="text",examples=['anonymized_120036.jpg','anonymized_1210515.jpg']).launch(share=False)