#import required libraries-----------------------------------------------
import streamlit as st
from tensorflow import keras
import tensorflow as tf
from PIL import Image
import numpy as np
import cv2

#loading model-----------------------------------------------------------
model=keras.models.load_model("3rdm_att_UNet_50epochs_acc.h5")

#User Interface----------------------------------------------------------
st.header("Segmentation of the Lower Left Third Molar in Panoramic X-ray Images Using Attention U-Net")

examples=["2.png","20.png","31.png"]

def load_image(image_file):
      img = Image.open(image_file)
      return img

st.subheader("Instruction:")
st.subheader("Please select from the provided samples or upload dental panoramic X-ray image")
image_file = st.file_uploader("Upload Images", type=["png","jpg","jpeg"])

col1, col2, col3 = st.columns(3)
with col1:
    ex=load_image(examples[0])
    st.image(ex,width=200)
    if st.button('Sample 1'):
        image_file=examples[0]

with col2:
    ex1=load_image(examples[1])
    st.image(ex1,width=200)
    if st.button('Sample 2'):
        image_file=examples[1]

with col3:
    ex2=load_image(examples[2])
    st.image(ex2,width=200)
    if st.button('Sample 3'):
        image_file=examples[2]
    
#main--------------------------------------------------------------------
   
if image_file is not None:

      img=load_image(image_file)
      
      st.text("Selected Image ....")
      st.image(img,width=850)
      
      img = np.asarray(img)     
      img = cv2.resize(img, (512, 256))
      img = cv2.cvtColor(img, cv2.COLOR_BAYER_GR2GRAY)
      img = np.expand_dims(img, axis=0)

      prediction = model.predict(img)

      output = prediction.reshape(256,512)


      if output is not None :      
          st.text("Result")  
          #st.write(output.shape)
          st.image(output,width=850)

      st.text("DONE")