import gradio

model_interfaces = gradio.Interface.load("models/ckpt/anything-v4.0")

def process_prompt(prompt):
    prompt=prompt.lower()
    print(prompt)
    image = model_interfaces(prompt)
    return image
    
sandbox = gradio.Interface(
    fn=process_prompt,
    inputs=[gradio.Textbox(label="Enter Prompt:")],
    outputs=[gradio.Image(label="Produced Image")],
    title="Text to Image", 
    examples=[["Female Adventurer portrait, rogue, tavern background"],
              ["female Adventurer portrait, barbarian, tavern background"],
              ["Magic Adventurer portrait,  old wizard, tavern background"],
              ["Male superhero portrait,  modern city, building background"],
              ["Magic Adventurer portrait,  old wizard, fire elementalist, tavern background, fire"], 
              ["Female Adventurer portrait, Druid, tavern background"],
              ["close up portrait Benedict Cumberbatch wizard of black magic, robe with hood,  Hogwart University, castle tower background, oil  painting on canvas"], 
              ["Adventurer portrait, cleric, rogue looking stranger, tavern background"]]
)

sandbox.queue(concurrency_count=10).launch(debug=True)
