import gradio as gr
from utils.predict import predict_action
import os
import glob

##Create list of examples to be loaded
example_list = glob.glob("examples/*")
example_list = list(map(lambda el:[el], example_list))


demo = gr.Blocks()


with demo:
    
    gr.Markdown("# **<p align='center'>Video Classification with Transformers</p>**")
    description="""# <p>
    <center>
    Demo de clasificador de video usando modelo híbrido basado ​​en Transformers con CNN, el objetivo es reconocer un segemento y recortarlo.
    <img src=\"https://raw.githubusercontent.com/All-Aideas/sea_apirest/main/logo.png\" alt=\"logo\" width=\"250\"/>
    </center>
    </p>
    """
    gr.Markdown(description)
    
    with gr.Tabs():
                
        with gr.TabItem("Upload & Predict"):
            with gr.Box():
                
                with gr.Row():
                    input_video = gr.Video(label="Input Video", show_label=True)
                    output_label = gr.Label(label="Model Output", show_label=True)
                    output_gif = gr.Image(label="Video Gif", show_label=True)
            
            gr.Markdown("**Predict**")
            
            with gr.Box():
                with gr.Row():
                    submit_button = gr.Button("Submit")
            
            gr.Markdown("**Ejemplos:**")
            gr.Markdown("El modelo puede clasificar videos pertenecientes a las siguientes clases: CricketShot, PlayingCello, Punch, ShavingBeard, TennisSwing.")
            # gr.Markdown("CricketShot, PlayingCello, Punch, ShavingBeard, TennisSwing")

            with gr.Column():
                gr.Examples(example_list, [input_video], [output_label,output_gif], predict_action, cache_examples=True)
        
    submit_button.click(predict_action, inputs=input_video, outputs=[output_label,output_gif])

demo.launch()
