from ocean_lib.config import Config
from ocean_lib.models.btoken import BToken #BToken is ERC20
from ocean_lib.ocean.ocean import Ocean
from ocean_lib.web3_internal.wallet import Wallet
from ocean_lib.web3_internal.currency import from_wei # wei is the smallest denomination of ether e.g. like cents
# from ocean_lib.web3_internal.currency import pretty_ether_and_wei
import streamlit as st
from web3 import Web3
from wallet_connect import connect

d = {
   'network' : 'https://rinkeby.infura.io/v3/d163c48816434b0bbb3ac3925d6c6c80',
   'BLOCK_CONFIRMATIONS': 0,
   'metadataCacheUri' : 'https://aquarius.oceanprotocol.com',
   'providerUri' : 'https://provider.rinkeby.oceanprotocol.com',
   'PROVIDER_ADDRESS': '0x00bd138abd70e2f00903268f3db08f2d25677c9e',
   'downloads.path': 'consume-downloads',
}

ocean = Ocean(d)

def wallet():
    
    lower_case_address = connect("wallet")
    address = ''
    if len(lower_case_address[0]) > 3:
        address = Web3.toChecksumAddress(lower_case_address[0])
    if len(address) > 3:

        OCEAN_token = BToken(ocean.web3, ocean.OCEAN_address)

        eth_balance = from_wei(ocean.web3.eth.get_balance(address))
        ocean_balance = from_wei(OCEAN_token.balanceOf(address))

        st.write(f'Address: {address}')
        st.write(f'ETH Balance: {eth_balance}')
        st.write(f'OCEAN Balance: {ocean_balance}')

st.header("Web3 Wallet")
text = """
This demo shows the balance of tokens in your Web3 wallet. 
If you do not have a Web3 wallet, see instructions on setting up a wallet in the links below.
Initially, your wallet should have no ETH and OCEAN tokens in it. 
You can then request ETH and OCEAN test tokens by entering your public address into faucets 
(follow the links at the bottom of the page). 
Then wait about 15 seconds and re-run the app for the same private key. 
This demo uses the Ocean Protocol Python library in the backend. 
For more information on the advantages of combinining Ocean and HuggingFace, 
check out the blog post link below.

Setup MetaMask: [https://www.oceanacademy.io/ocean101/chapter-8](https://www.oceanacademy.io/ocean101/chapter-8)

Get Rinkeby ETH: [https://faucet.rinkeby.io/](https://faucet.rinkeby.io/)

Get Test Ocean: [https://faucet.rinkeby.oceanprotocol.com/](https://faucet.rinkeby.oceanprotocol.com/)
"""
st.write(text)

wallet()