import gradio as gr

from ocean_lib.config import Config
from ocean_lib.models.compute_input import ComputeInput
from ocean_lib.ocean.ocean import Ocean
from ocean_lib.web3_internal.constants import ZERO_ADDRESS
from ocean_lib.web3_internal.currency import to_wei
from ocean_lib.web3_internal.wallet import Wallet

import os
import time

from io import StringIO, BytesIO
from PIL import Image
import pandas as pd
import matplotlib.pyplot as plt
import random
import numpy as np

config = Config('config.ini')
ocean = Ocean(config)

def compute(
    private_key
):
    
    wallet = Wallet(ocean.web3, 
                    private_key, 
                    transaction_timeout=20, 
                    block_confirmations=config.block_confirmations)
    
    address = wallet.address

    DATA_ddo = ocean.assets.resolve("did:op:62D5Db3778ABAABa808e53eB2AB28181aaCCF747")
    data_token = ocean.get_data_token(DATA_ddo.data_token_address)
    token_address = data_token.address

    ALG_ddo = ocean.assets.resolve("did:op:7D87e472921536da4bd02CB566099C18ed2F40A5")
    alg_token = ocean.get_data_token(ALG_ddo.data_token_address)

    DATA_did = DATA_ddo.did
    ALG_did = ALG_ddo.did

    compute_service = DATA_ddo.get_service('compute')
    algo_service = ALG_ddo.get_service('access')

    # order & pay for dataset
    dataset_order_requirements = ocean.assets.order(
        DATA_did, wallet.address, service_type=compute_service.type
    )
    time.sleep(30)
    DATA_order_tx_id = ocean.assets.pay_for_service(
            ocean.web3,
            dataset_order_requirements.amount,
            dataset_order_requirements.data_token_address,
            DATA_did,
            compute_service.index,
            ZERO_ADDRESS,
            wallet,
            dataset_order_requirements.computeAddress,
        )
    print('after data')
    # order & pay for algo
    algo_order_requirements = ocean.assets.order(
        ALG_did, wallet.address, service_type=algo_service.type
    )
    time.sleep(30)
    ALG_order_tx_id = ocean.assets.pay_for_service(
            ocean.web3,
            algo_order_requirements.amount,
            algo_order_requirements.data_token_address,
            ALG_did,
            algo_service.index,
            ZERO_ADDRESS,
            wallet,
            algo_order_requirements.computeAddress,
    )
    print('after algo')
    compute_inputs = [ComputeInput(DATA_did, 
                                   DATA_order_tx_id, 
                                   compute_service.index)]

    job_id = ocean.compute.start(
        compute_inputs,
        wallet,
        algorithm_did=ALG_did,
        algorithm_tx_id=ALG_order_tx_id,
        algorithm_data_token=alg_token.address
    )

    status_dict = ocean.compute.status(DATA_did, job_id, wallet)
    while status_dict['statusText'] != 'Job finished':
        status_dict = ocean.compute.status(DATA_did, job_id, wallet)
        time.sleep(10)
        
    final_df_data = ocean.compute.result_file(DATA_did, 
                                       job_id, 
                                       0, 
                                       wallet)
    s = str(final_df_data,'utf-8')
    data = StringIO(s) 
    final_df = pd.read_csv(data) #.drop('Unnamed: 0', 1)
    
    image_data = ocean.compute.result_file(DATA_did, 
                                           job_id,
                                           1, 
                                           wallet)
    image = Image.open(BytesIO(image_data))
    
    image = np.array(image)
    
    samps = random.choices([0,1,2,3,4,5,6,7,8,9], k=3)
    imgs = []
    for i in samps:
        imgs.append(Image.fromarray(np.array(image )[300*i:300*i+300]))
    
    print('compute done')
    return *imgs, final_df
                                       

# description = ()


interface = gr.Interface(
    compute,
    [
        gr.inputs.Textbox(label="Private Key"),
    ],
    [
        gr.outputs.Image(label="Sample Results 1"),
        gr.outputs.Image(label="Sample Results 2"),
        gr.outputs.Image(label="Sample Results 3"),
        gr.outputs.Dataframe(label="Final dataframe"),
    ],
    title="Inference demo for nCight-Algovera Medical Image Classification",
#    description=description,
    theme="huggingface",
)

interface.launch(debug=True, enable_queue=True)                     
