import time

import gradio as gr
from sentence_transformers import SentenceTransformer

import httpx
import json

from utils import get_tags_for_prompts, get_mubert_tags_embeddings, get_pat

minilm = SentenceTransformer('all-MiniLM-L6-v2')
mubert_tags_embeddings = get_mubert_tags_embeddings(minilm)


def get_track_by_tags(tags, pat, duration, mode, maxit=20, loop=False):
    if loop:
        mode = "loop"
    else:
        mode = "track"
    r = httpx.post('https://api-b2b.mubert.com/v2/RecordTrackTTM',
                   json={
                       "method": "RecordTrackTTM",
                       "params": {
                           "pat": pat,
                           "duration": duration,
                           "tags": tags,
                           "mode": mode
                       }
                   })

    rdata = json.loads(r.text)
    assert rdata['status'] == 1, rdata['error']['text']
    trackurl = rdata['data']['tasks'][0]['download_link']

    print('Generating track ', end='')
    for i in range(maxit):
        r = httpx.get(trackurl)
        if r.status_code == 200:
            return trackurl
        time.sleep(1)


def generate_track_by_prompt(email, prompt, duration, mode, loop=False):
    try:
        pat = get_pat(email)
        _, tags = get_tags_for_prompts(minilm, mubert_tags_embeddings, [prompt, ])[0]
        return get_track_by_tags(tags, pat, int(duration), mode, loop=loop), "Success", ",".join(tags)
    except Exception as e:
        return None, str(e), ""


block = gr.Blocks(css=".mx-auto{max-width:550px}.svelte-10ogue4 {background: rgba(0,0,0,0.0);width:100%;border: 0px}.gradio-container {background: rgba(0,0,0,0.0);border: 0px}.gr-block {background: rgba(0,0,0,0.0);border: 0px} #component-4 {opacity: 0.8;background: linear-gradient(#233581, #E23F9C);border: 0px;margin-bottom: 17px;border-radius: 10px;}#component-5 {opacity: 0.8;background: linear-gradient(#E23F9C, #233581);border: 0px;margin-bottom: 17px;border-radius: 10px;}.gr-form{background: rgba(0,0,0,0.0);border: 0px}.gr-text-input {background: rgba(255,255,255,1);border: 0px}.text-gray-500 {color: #FFFFFF;font-weight: 600;text-align: center;font-size: 18px;}#component-1 {height: 0px;}#range_id_0 {opacity: 0.5;border-radius: 8px;-webkit-appearance: none; width: 60%; height: 15px; background-color: #E64CAC; background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#233581, #E23F9C), to(#E956B8)); background-image: -webkit-linear-gradient(right, #233581, #E956B8); background-image: -moz-linear-gradient(right, #233581, #E956B8); background-image: -ms-linear-gradient(right, #233581, #E956B8); background-image: -o-linear-gradient(right, #233581, #E956B8)}#component-6{opacity: 0.9;background: linear-gradient(#233581, #515A7F);border-radius: 10px}#component-7{margin-top: 7px;margin-bottom: 7px;text-align: center;display:inline;opacity: 0.9;background: linear-gradient(#515A7F, #515A7F);border-radius: 10px;}.ml-2{color: #FFFFFF;}#component-8 {height: 100px;z-index:99;background: linear-gradient(#515A7F, #515A7F);border-radius: 10px;opacity: 0.9}.absolute{background: linear-gradient(#EC5CC0, #D61B70);border: 0px}.feather{color: #FFFFFF;} .mt-7{z-index:100;background: linear-gradient(#515A7F, #515A7F);border-radius: 10px;} .gr-button{margin-left: 30%;width:40%;justify-content: center; background: linear-gradient(#EC5DC1, #D61A6F); padding: 0 12px; border: none; border-radius: 8px; box-shadow: 0 30px 15px rgba(0, 0, 0, 0.15); outline: none; color: #FFF; font: 400 16px/2.5 Nunito, Sans-serif; text-transform: uppercase; cursor: pointer;}#component-11{justify-content: center;text-align: center;margin-top:10px;border: 0px}.mx-auto{background: rgba(0,0,0,0.0);width:100%;border: 0px;padding:0 0 0 0}#component-9 {margin-top: 5px;opacity: 0.8;padding: 3px;background: linear-gradient(#515A7F, #515A7F);border-radius: 10px;}#component-10{margin-top: 5px;opacity: 0.8;padding: 3px;background: linear-gradient(#515A7F, #515A7F);border-radius: 10px;}#component-12{display:none}.gr-input-label{margin-right: 1px;width:71px;font-weight: 400;background: linear-gradient(#584C84, #2C3D7F);text-align: center;border: 0px}.font-semibold{display:none}")

 

with block:
    gr.HTML(
        """ 
       
           <noindex> <div hidden style="text-align: center; max-width: 700px; margin: 0 auto;">
              <div
                style="
                  display: inline-flex;
                  align-items: center;
                  gap: 0.8rem;
                  font-size: 1.75rem;
                "
              >
                <h1 hidden style="font-weight: 900; margin-bottom: 7px;">
                  Mubert
                </h1>
              </div>
              <p style="margin-bottom: 10px; font-size: 94%">
                All music is generated by Mubert API – <a href="https://mubert.com" style="text-decoration: underline;" target="_blank">www.mubert.com</a>
              </p>
            </div> </noindex>
        """
    )
    with gr.Group():
        with gr.Box():
            email = gr.Textbox(label="email")
            prompt = gr.Textbox(label="Text example (bass drum cyberpunk)")
            duration = gr.Slider(label="Time (seconds)", value=30, maximum=250,)
            mode = gr.Radio(["track", "loop", "jingle", "mix"], label="Track Type")
            out = gr.Audio()
            result_msg = gr.Text(label="System messages")
            tags = gr.Text(label="Generated track tags")
            btn = gr.Button("Create").style(full_width=True)
            is_loop = gr.Checkbox(label="Loop a track")
        btn.click(fn=generate_track_by_prompt, inputs=[email, prompt, duration, mode, is_loop], outputs=[out, result_msg, tags])
        gr.HTML('''
       <noindex>  <div hidden class="footer" style="text-align: center; max-width: 700px; margin: 0 auto;">
                    <p>Demo by <a href="https://huggingface.co/Mubert" style="text-decoration: underline;" target="_blank">Mubert</a>
                    </p>
        </div> </noindex>
        ''')

block.launch()