import gradio as gr
import os


os.system("git clone https://github.com/megvii-research/NAFNet")
os.system("mv NAFNet/* ./")
os.system("mv *.pth experiments/pretrained_models/")
os.system("python3 setup.py develop --no_cuda_ext --user")


def inference(image, task):
    if not os.path.exists('tmp'):
      os.system('mkdir tmp')
    image.save("tmp/lq_image.png", "PNG")
    
    if task == 'Denoising':
      os.system("python basicsr/demo.py -opt options/test/SIDD/NAFNet-width64.yml --input_path ./tmp/lq_image.png --output_path ./tmp/image.png")
  
    if task == 'Deblurring':
      os.system("python basicsr/demo.py -opt options/test/REDS/NAFNet-width64.yml --input_path ./tmp/lq_image.png --output_path ./tmp/image.png")
  
    return 'tmp/image.png'
   
title = "Restoration APP Visual"
description = ""
article = ""
#description = "Gradio demo for <b>NAFNet: Nonlinear Activation Free Network for Image Restoration</b>. NAFNet achieves state-of-the-art performance on three tasks: image denoising, image debluring and stereo image super-resolution (SR). See the paper and project page for detailed results below. Here, we provide a demo for image denoise and deblur. To use it, simply upload your image, or click one of the examples to load them. Inference needs some time since this demo uses CPU."
#article = "<p style='text-align: center'><a href='https://arxiv.org/abs/2204.04676' target='_blank'>Simple Baselines for Image Restoration</a> | <a href='https://arxiv.org/abs/2204.08714' target='_blank'>NAFSSR: Stereo Image Super-Resolution Using NAFNet</a>  | <a href='https://github.com/megvii-research/NAFNet' target='_blank'> Github Repo</a></p>"


examples = [['demo/noisy.png', 'Denoising'],
            ['demo/blurry.jpg', 'Deblurring']]
            
iface = gr.Interface(
    inference, 
    [gr.inputs.Image(type="pil", label="Input"),
    gr.inputs.Radio(["Denoising", "Deblurring"], default="Denoising", label='task'),], 
    gr.outputs.Image(type="file", label="Output"),
    title=title,
    description=description,
    article=article,
    enable_queue=True,
    examples=examples
    )
iface.launch(debug=True,enable_queue=True)