import gradio as gr
import os
 
def inference(image, task):
    if not os.path.exists('tmp'):
      os.system('mkdir tmp')
    image.save("tmp/lq_image.png", "PNG")
    
    if task == 'Dehazing':
      os.system("python Dehazing.py --test_path ./tmp/lq_image.png --save_path ./tmp/ --pk_path model_zoo/Haze4k.tjm")
  
    if task == 'LLIE':
      os.system("python Lowlight.py --test_path ./tmp/lq_image.png --save_path ./tmp/ --pk_path model_zoo/Lowlight.pth")
    
    if task == 'SuperResolutionx2':
      os.system("python SuperResolution.py --test_path ./tmp/lq_image.png --save_path ./tmp/ --pk_path model_zoo/SRx2.pth --scale 2")
    
    if task == 'SuperResolutionx3':
      os.system("python SuperResolution.py --test_path ./tmp/lq_image.png --save_path ./tmp/ --pk_path model_zoo/SRx3.pth --scale 3")
      
    if task == 'SuperResolutionx4':
      os.system("python SuperResolution.py --test_path ./tmp/lq_image.png --save_path ./tmp/ --pk_path model_zoo/SRx4.pth --scale 4")
        
    if task == 'Underwater':
      os.system("python Underwater.py --test_path ./tmp/lq_image.png --save_path ./tmp/ --pk_path model_zoo/underwater.pth")
      
    return 'tmp/output.png'
   
title = "基于光学传播建模的复杂水下成像智能复原方法<br><font size=3>高红霞</font><br><font size=3>华南理工大学</font><br>"
description = " 简介：项目组结合多年来关于基于光学成像建模的图像复原方法的理论研究基础，从光的物理传播建模出发，开展如下研究：建立描述复杂水体中介质的吸收、前后散射等主要成像退化特征的光学成像模型；基于光学成像模型和低秩约束实现自适应智能复原；以计算机视觉理论和光学成像模型为基础，实现消除多种退化效应的深度学习复原模型。在前期的图像复原理论研究的基础上，后续展开在雾天、低照度、低分辨率等场景下的传统与深度学习复原方法的研究。"
article = "相关成果：<br>[1]Ye Cai, Hongxia Gao*, Shicheng Niu, Tian Qi. A multi-stage restoration method for degraded images with light scattering and absorption. Proceeding of 26th International Conference on Pattern Recognition (ICPR 2022).<br>[2]Ye Cai, Lan Luo, Hongxia Gao*, Shicheng Niu, Weipeng Yang , Tian Qi, Guoheng Liang. Haze Removal Using a Hybrid Convolutional Sparse Representation Model. The 14th International Conference on Digital Image Processing (ICDIP).<br>[3] Hongxia Gao, Zhanhong Chen, Binyang Huang*, Jiahe Chen, Zhifu Li. Image Super Resolution Based on Conditional Generative Adversarial Network. IET Image Processing(SCI三区)，2020, 14(13): 3006-3013.(SCI收录- 000595800300006).<br>[4] Weipeng Yang, Hongxia Gao, Shasha Huang, Shicheng Niu, Hongsheng Chen, Guoheng Liang. Low-light image enhancement under mixed noise model with Tensor Representation. CAAI International Conference on Artificial Intelligence(CICAI)."
#description = "Gradio demo for <b>NAFNet: Nonlinear Activation Free Network for Image Restoration</b>. NAFNet achieves state-of-the-art performance on three tasks: image denoising, image debluring and stereo image super-resolution (SR). See the paper and project page for detailed results below. Here, we provide a demo for image denoise and deblur. To use it, simply upload your image, or click one of the examples to load them. Inference needs some time since this demo uses CPU."
#article = "<p style='text-align: center'><a href='https://arxiv.org/abs/2204.04676' target='_blank'>Simple Baselines for Image Restoration</a> | <a href='https://arxiv.org/abs/2204.08714' target='_blank'>NAFSSR: Stereo Image Super-Resolution Using NAFNet</a>  | <a href='https://github.com/megvii-research/NAFNet' target='_blank'> Github Repo</a></p>"


examples = [['demo/underwater.jpg', 'Underwater'],
            ['demo/low.jpg', 'LLIE'],
            ['demo/dehaze.jpg', 'Dehazing'],
            ['demo/sr.png', 'SuperResolutionx2']]


#examples = [['demo/low.jpg', 'LLIE']]

'''                                           
iface = gr.Interface(
    inference, 
    [gr.inputs.Image(type="pil", label="Input"),
    gr.inputs.Radio(["LLIE"], default="LLIE", label='task'),], 
    gr.outputs.Image(type="file", label="Output"),
    title=title,
    description=description,
    article=article,
    enable_queue=True,
    examples=examples
    )
iface.launch(debug=True,enable_queue=True)
'''
iface = gr.Interface(
    inference, 
    [gr.inputs.Image(type="pil", label="Input"),
    gr.inputs.Radio(["Underwater", "LLIE", "Dehazing", "SuperResolutionx2", "SuperResolutionx3", "SuperResolutionx4"], default="Underwater", label='task'),], 
    gr.outputs.Image(type="file", label="Output"),
    title=title,
    description=description,
    article=article,
    enable_queue=True,
    examples=examples
    )
iface.launch(debug=True,enable_queue=True)
