from PIL import Image
import numpy as np
import librosa
import gradio as gr

def img_to_audio(image, time=3.0, rate=22050, n_fft=1024, n_iter=64):
    # load image
    img = Image.fromarray(image).convert("L")
    # calculate spectrogram size 
    spec_shape = (int(librosa.time_to_frames(1.0, sr=rate, hop_length=n_fft//2, n_fft=n_fft) * time), n_fft)
    spec = np.asarray(img.resize(spec_shape))
    print(spec.shape)
    spec = np.interp(spec, (spec.min(), spec.max()), (-50, 30))
    spec = librosa.db_to_amplitude(spec)
    audio = librosa.griffinlim(spec, n_iter=n_iter)
    return (rate, audio)

time = gr.Number(3.0, label="audio time")
image = gr.Image(label="image to sonify")
n_fft = gr.Number(1024, label="n_fft")

def main(image, time, n_fft):
    return img_to_audio(image, time=time, n_fft=int(n_fft))

desc = "Upload an image you would like to hear."

interface = gr.Interface(fn=main, inputs=[image, time, n_fft], outputs="audio", title="Simple Image Sonification", description=desc)

interface.launch()