import os
os.system("pip uninstall -y gradio")
os.system("pip install gradio==3.44.4")
import gradio as gr
from sklearn.datasets import fetch_california_housing
from sklearn.model_selection import train_test_split
from sklearn.linear_model import LinearRegression


data = fetch_california_housing()
X = data.data
y = data.target


X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)


X_train = X_train[:, :5]
X_test = X_test[:, :5]

model = LinearRegression()
model.fit(X_train, y_train)


def predict_housing_price(sqft, bedrooms, bathrooms, latitude, longitude):

    if sqft is None or bedrooms is None or bathrooms is None or latitude is None or longitude is None:
        return "Please provide all input values."


    try:
        sqft = float(sqft)
        bedrooms = float(bedrooms)
        bathrooms = float(bathrooms)
        latitude = float(latitude)
        longitude = float(longitude)
    except ValueError:
        return "Invalid input. Please provide numeric values."


    input_features = [sqft, bedrooms, bathrooms, latitude, longitude]
    predicted_price = model.predict([input_features])[0]


    return f"Predicted Price: ${predicted_price:.2f}"

input_components = [
    gr.inputs.Slider(label="Sqft", minimum=0, maximum=5000),
    gr.inputs.Slider(label="Bedrooms", minimum=0, maximum=10),
    gr.inputs.Slider(label="Bathrooms", minimum=0, maximum=5),
    gr.inputs.Slider(label="Latitude", minimum=32.5, maximum=35),
    gr.inputs.Slider(label="Longitude", minimum=-125, maximum=-120)
]

iface = gr.Interface(
    fn=predict_housing_price,
    inputs=input_components,
    outputs="text"  
)

iface.launch()