"""
this model only supports english since text to speech is an english only model
"""
import os, time
import openai
import gradio as gr
from dotenv import load_dotenv
import pinecone

"""
Connecting to Open AI API
"""
load_dotenv()
openai.organization = os.getenv("OPENAI_ORG")
openai.api_key = os.getenv("OPENAI_API_KEY")
EMBEDDING_MODEL = "text-embedding-ada-002"
"""
Connecting to pincone API and assign index
"""
index_name = "luludemo"
pinecone.init(
    api_key=os.getenv("Pinecone_KEY"),
    environment=os.getenv("Pinecone_ENV")
)

"""
run cosin similarity to find context
"""
def LLMSearch(question):
    index = pinecone.Index(index_name)
    query = openai.Embedding.create(input=question, model=EMBEDDING_MODEL)["data"][0]["embedding"] # embed the user query into an embedding vector
    res = index.query(query, top_k=3, include_metadata=True) # run cosin similarity to search the most relavent embeded content; this is done in pinecone only
    contexts = [
            x['metadata']['text'] for x in res['matches']
        ]
    merged_context = "".join(contexts)
    contextwithQuestion = "Context: " + "\n"+ merged_context + "*End of the context*" + "\n\n" +  "Question: " + question
    print(contextwithQuestion)
    """
    pass the transcripted text to GPT
    """
    messages = [
    {"role": "system", 
        "content": 
        "You are an assistant that answers questions only based on the context provided. Before each question, some context will be provided.\
        Context starts with 'Context:' and end with '*End of the context*'. Once you receive all the context, you will consider all of them to answer the questions.\
        It is very important to answer the question as honestly as possible.\
        If you are not sure about the answer based on the context provided, you can still try to come up with an answer but you must also tell the user that you are not confident about the answer and that the user should look for a secondary source to confirm the answer.\
        It is very important to answer the questions politely. It is very important to answer the question in great detail.\
        Once you receive all the context, you will receive a question that starts with 'Question:'. Once you receive the question, you can answer the question.\
        "}
    ] 
    messages.append({"role": "user", "content":contextwithQuestion}) ## add user input to the list of message

    response = openai.ChatCompletion.create(
        model="gpt-3.5-turbo",
        messages=messages
    ) ## pass the list of message to GPT

    return response["choices"][0]["message"]["content"] ## add GPT response to the list of message


with gr.Blocks() as demo:
    chatbot = gr.Chatbot()
    msg = gr.Textbox()
    clear = gr.Button("Clear")

    def user(user_message, history):
        return "", history + [[user_message, None]]


    def bot(history):
            bot_message = LLMSearch(history[-1][0])
            history[-1][1] = bot_message
            time.sleep(1)
            return history
    
    msg.submit(user, [msg, chatbot], [msg, chatbot], queue=False).then(
        bot, chatbot, chatbot
    )
    clear.click(lambda: None, None, chatbot, queue=False)

demo.launch(debug=True)


